/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.client.screen;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class ByteBufferProcessor {
    private final BlockingQueue<ByteBuffer> inputQueue = new LinkedBlockingQueue<ByteBuffer>();
    private final BlockingQueue<ByteBuffer> outputQueue = new LinkedBlockingQueue<ByteBuffer>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final Function<ByteBuffer, ByteBuffer> processingFunction;
    private volatile boolean isRunning;

    public ByteBufferProcessor(Function<ByteBuffer, ByteBuffer> processingFunction) {
        this.processingFunction = processingFunction;
        this.isRunning = true;
        this.startProcessing();
    }

    private void startProcessing() {
        this.executorService.submit(() -> {
            while (this.isRunning || !this.inputQueue.isEmpty()) {
                try {
                    ByteBuffer input = this.inputQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (input == null) continue;
                    ByteBuffer result = this.processingFunction.apply(input);
                    this.outputQueue.put(result);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
    }

    public void submitForProcessing(ByteBuffer buffer) {
        if (!this.isRunning) {
            throw new IllegalStateException("Processor has been shutdown");
        }
        try {
            this.inputQueue.put(buffer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failed to submit buffer for processing", e);
        }
    }

    public ByteBuffer getProcessedBuffer() throws InterruptedException {
        return this.outputQueue.poll(100L, TimeUnit.MILLISECONDS);
    }

    public boolean hasProcessedBuffers() {
        return !this.outputQueue.isEmpty();
    }

    public boolean hasWork() {
        return !this.inputQueue.isEmpty();
    }

    public void shutdown() {
        this.isRunning = false;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

