/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.nbtedit;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public enum NBTEditResponseHandlers {
    INSTANCE;

    public static final String ITEM = "item";
    public static final String BLOCK = "block";
    public static final String PLAYER = "player";
    public static final String ENTITY = "entity";
    private final Map<String, NBTResponseHandler> MAP = new ConcurrentHashMap<String, NBTResponseHandler>();

    public static void registerBuiltinHandlers() {
        INSTANCE.registerHandler(ITEM, (player, info, data) -> ItemStack.parse((HolderLookup.Provider)player.registryAccess(), (Tag)data).ifPresent(stack -> player.setItemInHand(InteractionHand.MAIN_HAND, stack)));
        INSTANCE.registerHandler(BLOCK, (player, info, data) -> NbtUtils.readBlockPos((CompoundTag)info, (String)"pos").ifPresent(pos -> {
            BlockEntity blockEntity;
            if (player.level().isLoaded(pos) && (blockEntity = player.level().getBlockEntity(pos)) != null) {
                data.putInt("x", pos.getX());
                data.putInt("y", pos.getY());
                data.putInt("z", pos.getZ());
                data.putString("id", info.getString("id"));
                blockEntity.loadWithComponents(data, (HolderLookup.Provider)player.level().registryAccess());
                blockEntity.setChanged();
                player.level().sendBlockUpdated(pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            }
        }));
        INSTANCE.registerHandler(PLAYER, (player, info, data) -> {
            ServerPlayer targetPlayer;
            if (player.getServer() != null && (targetPlayer = player.getServer().getPlayerList().getPlayer(info.getUUID("id"))) != null) {
                UUID uuid = targetPlayer.getUUID();
                targetPlayer.load(data);
                targetPlayer.setUUID(uuid);
                targetPlayer.moveTo(targetPlayer.getX(), targetPlayer.getY(), targetPlayer.getZ());
            }
        });
        INSTANCE.registerHandler(ENTITY, (player, info, data) -> {
            Entity entity = player.level().getEntity(info.getInt("id"));
            if (entity != null) {
                UUID uuid = entity.getUUID();
                entity.load(data);
                entity.setUUID(uuid);
            }
        });
    }

    public void registerHandler(String name, NBTResponseHandler handler) {
        this.MAP.put(name, handler);
    }

    public void handleResponse(String name, ServerPlayer player, CompoundTag info, CompoundTag data) {
        this.MAP.getOrDefault(name, NBTResponseHandler.NONE).handleResponse(player, info, data);
    }

    @FunctionalInterface
    public static interface NBTResponseHandler {
        public static final NBTResponseHandler NONE = (player, info, data) -> {};

        public void handleResponse(ServerPlayer var1, CompoundTag var2, CompoundTag var3);
    }
}

