/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.ITiabConfig;
import org.mangorage.tiab.common.api.ITiabItemSearch;
import org.mangorage.tiab.common.api.LoaderSide;
import org.mangorage.tiab.common.api.impl.IStoredTimeComponent;
import org.mangorage.tiab.common.api.impl.ITiabItem;
import org.mangorage.tiab.common.api.impl.ITimeAcceleratorEntity;
import org.mangorage.tiab.common.commands.TiabCommands;
import org.mangorage.tiab.common.core.StoredTimeComponent;
import org.mangorage.tiab.common.entities.TimeAcceleratorEntity;

public abstract class TiabMod
implements ICommonTimeInABottleAPI {
    private static ICommonTimeInABottleAPI API;
    private static final TagKey<Block> TIAB_UN_ACCELERATABLE;
    private int ticks = 0;
    private final List<ITiabItemSearch> itemSearchList = new ObjectArrayList();
    private final LoaderSide loaderSide;
    private final ITiabConfig defaultConfig = new ITiabConfig(this){};

    public static Supplier<ICommonTimeInABottleAPI> getAPIHolder() {
        return () -> API;
    }

    public TiabMod(LoaderSide loaderSide) {
        this.loaderSide = loaderSide;
        API = this;
        this.registerItemSearch(p -> {
            for (ItemStack item : p.getInventory().items) {
                if (!(item.getItem() instanceof ITiabItem)) continue;
                return item;
            }
            return null;
        });
    }

    @Override
    public List<ITiabItemSearch> getSearchHandlers() {
        return List.copyOf(this.itemSearchList);
    }

    @Override
    public String getModId() {
        return "tiab";
    }

    @Override
    public LoaderSide getLoaderSide() {
        return this.loaderSide;
    }

    protected void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tiab").then(TiabCommands.addTimeCommand)).then(TiabCommands.removeTimeCommand));
    }

    @Override
    public void registerItemSearch(ITiabItemSearch search) {
        this.itemSearchList.add(search);
    }

    @Override
    public ItemStack findTiabItem(Player player) {
        for (ITiabItemSearch search : this.itemSearchList) {
            ItemStack item = search.findItem(player);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public TagKey<Block> getTagKey() {
        return TIAB_UN_ACCELERATABLE;
    }

    @Override
    public ITiabConfig getConfig() {
        return this.defaultConfig;
    }

    @Override
    public IStoredTimeComponent createStoredTimeComponent(int stored, int total) {
        return new StoredTimeComponent(stored, total);
    }

    @Override
    public ITimeAcceleratorEntity createEntity(ServerLevel level) {
        return (ITimeAcceleratorEntity)this.getRegistration().getAcceleratorEntityType().create((Level)level);
    }

    @Override
    public List<? extends ITimeAcceleratorEntity> getEntities(Level level, AABB aabb) {
        return level.getEntitiesOfClass(TimeAcceleratorEntity.class, aabb);
    }

    protected void tickPlayer(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getTiabItem().tickPlayer(player, 20);
        }
    }

    static {
        TIAB_UN_ACCELERATABLE = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tiab", (String)"un_acceleratable"));
    }
}

