/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="productivemetalworks", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue FOUNDRY_MAX_VOLUME = BUILDER.comment("Max internal volume of the foundry multiblock").defineInRange("foundryMaxVolume", 1024, 1, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue FOUNDRY_MAX_CIRCUMFERENCE = BUILDER.comment("Max circumference of the foundry multiblock").defineInRange("foundryMaxCircumference", 200, 1, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue FOUNDRY_MAX_HEIGHT = BUILDER.comment("Max height of the foundry multiblock").defineInRange("foundryMaxHeight", 20, 1, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue FOUNDRY_FLUID_CAPACITY_PER_BLOCK_VOLUME = BUILDER.comment("Number of mb per block volume").defineInRange("foundryFluidCapacityPerBlockVolume", 1000, 1, Integer.MAX_VALUE);
    private static final ModConfigSpec.IntValue FOUNDRY_TANK_TICK_RATE = BUILDER.comment("How many ticks between attempts at sharing fluid with tanks below it").defineInRange("foundryTankTickRate", 21, 1, Integer.MAX_VALUE);
    private static final ModConfigSpec.BooleanValue FOUNDRY_DAMAGE_ENTITIES = BUILDER.comment("Should an active foundry damage entities inside it").define("foundryDamageEntities", true);
    private static final ModConfigSpec.BooleanValue FOUNDRY_COLLECT_ITEMS = BUILDER.comment("Should an active foundry collect items dropped inside it").define("foundryCollectItems", true);
    private static final ModConfigSpec.BooleanValue FOUNDRY_RENDER_INVENTORY = BUILDER.comment("Should an active foundry render its inventory inside the multiblock").define("foundryRenderInventory", true);
    private static final ModConfigSpec.DoubleValue FOUNDRY_COOLING_MODIFIER = BUILDER.comment("The cooling time of cast items is the number of mb used in the recipe divided by this number").defineInRange("foundryCoolingModifier", 4.0, 1.0, 2.147483647E9);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int foundryMaxVolume;
    public static int foundryMaxCircumference;
    public static int foundryMaxHeight;
    public static int foundryFluidCapacityPerBlockVolume;
    public static int foundryTankTickRate;
    public static boolean foundryDamageEntities;
    public static boolean foundryCollectItems;
    public static boolean foundryRenderInventory;
    public static double foundryCoolingModifier;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        foundryMaxVolume = (Integer)FOUNDRY_MAX_VOLUME.get();
        foundryMaxCircumference = (Integer)FOUNDRY_MAX_CIRCUMFERENCE.get();
        foundryMaxHeight = (Integer)FOUNDRY_MAX_HEIGHT.get();
        foundryFluidCapacityPerBlockVolume = (Integer)FOUNDRY_FLUID_CAPACITY_PER_BLOCK_VOLUME.get();
        foundryTankTickRate = (Integer)FOUNDRY_TANK_TICK_RATE.get();
        foundryDamageEntities = (Boolean)FOUNDRY_DAMAGE_ENTITIES.get();
        foundryCollectItems = (Boolean)FOUNDRY_COLLECT_ITEMS.get();
        foundryRenderInventory = (Boolean)FOUNDRY_RENDER_INVENTORY.get();
        foundryCoolingModifier = (Double)FOUNDRY_COOLING_MODIFIER.get();
    }
}

