/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gems.block.GemBlock;
import net.silentchaos512.gems.util.Gems;

public class GemLampBlock
extends GemBlock {
    private final State lampState;

    public GemLampBlock(Gems gem, State lampState, BlockBehaviour.Properties properties) {
        super(gem, "gem_lamp" + (lampState.inverted ? "_inverted" : ""), properties);
        this.lampState = lampState;
    }

    private void checkAndUpdateState(Level world, BlockPos pos) {
        boolean powered;
        State newLampState;
        if (!world.isClientSide && (newLampState = this.lampState.withPower(powered = world.hasNeighborSignal(pos))) != this.lampState) {
            BlockState newState = this.gem.getLamp(newLampState).defaultBlockState();
            world.setBlock(pos, newState, 2);
        }
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean p_220082_5_) {
        this.checkAndUpdateState(worldIn, pos);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        this.checkAndUpdateState(worldIn, pos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.checkAndUpdateState((Level)world, pos);
    }

    public static enum State {
        OFF(false, false),
        ON(true, false),
        INVERTED_ON(true, true),
        INVERTED_OFF(false, true);

        private final boolean lit;
        private final boolean inverted;

        private State(boolean lit, boolean inverted) {
            this.lit = lit;
            this.inverted = inverted;
        }

        public boolean lit() {
            return this.lit;
        }

        public boolean inverted() {
            return this.inverted;
        }

        public boolean hasItem() {
            return this.lit == this.inverted;
        }

        public State withPower(boolean powered) {
            if (this.inverted) {
                return powered ? INVERTED_OFF : INVERTED_ON;
            }
            return powered ? ON : OFF;
        }
    }
}

