/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLLoader;
import net.silentchaos512.gems.GemsConfig;
import net.silentchaos512.gems.client.SilentGemsClient;
import net.silentchaos512.gems.setup.Registration;
import net.silentchaos512.gems.util.TextUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="silentgems")
public class SilentGems {
    public static final String MOD_ID = "silentgems";
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOM_SOURCE = RandomSource.create();
    public static final Logger LOGGER = LogManager.getLogger((String)"Silent's Gems");
    public static final TextUtil TEXT = new TextUtil("silentgems");

    public SilentGems(IEventBus modEventBus, ModContainer modContainer) {
        Registration.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GemsConfig.COMMON_SPEC);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            new SilentGemsClient(modContainer);
        }
    }

    public static String getVersion() {
        Optional o = ModList.get().getModContainerById(MOD_ID);
        if (o.isPresent()) {
            return ((ModContainer)o.get()).getModInfo().getVersion().toString();
        }
        return "0.0.0";
    }

    public static boolean isDevBuild() {
        return "NONE".equals(SilentGems.getVersion());
    }

    public static ResourceLocation getId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @Nullable
    public static ResourceLocation getIdWithDefaultNamespace(String name) {
        if (name.contains(":")) {
            return ResourceLocation.tryParse((String)name);
        }
        return ResourceLocation.tryParse((String)("silentgems:" + name));
    }

    public static String shortenId(@Nullable ResourceLocation id) {
        if (id == null) {
            return "null";
        }
        if (MOD_ID.equals(id.getNamespace())) {
            return id.getPath();
        }
        return id.toString();
    }
}

