/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import com.google.common.collect.ImmutableSet;
import dev.wuffs.squatgrow.SquatGrow;
import dev.wuffs.squatgrow.SquatPlatform;
import dev.wuffs.squatgrow.actions.Action;
import dev.wuffs.squatgrow.actions.ActionContext;
import dev.wuffs.squatgrow.actions.Actions;
import dev.wuffs.squatgrow.config.SquatGrowConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class SquatAction {
    public static void performAction(Level level, Player player) {
        if (level.isClientSide) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!SquatGrow.config.allowAdventureTwerking && serverPlayer.gameMode.getGameModeForPlayer() == GameType.ADVENTURE) {
            return;
        }
        if (!SquatPlatform.isSquatGrowEnabled(serverPlayer)) {
            return;
        }
        Pair<Boolean, List<ItemStack>> requirementsTest = SquatAction.passesRequirements(player);
        if (!((Boolean)requirementsTest.getKey()).booleanValue()) {
            return;
        }
        SquatAction.grow(level, (ServerPlayer)player, (List)requirementsTest.getValue());
    }

    public static Pair<Boolean, List<ItemStack>> passesRequirements(Player player) {
        ArrayList<ItemStack> itemsThatHandleDamage = new ArrayList<ItemStack>();
        if (SquatGrow.config.requireHoe) {
            ItemStack matchedItem = SquatAction.getMatchingHeldItem(player, Collections.emptyList(), List.of(ItemTags.HOES));
            if (!matchedItem.isEmpty()) {
                itemsThatHandleDamage.add(matchedItem);
                return Pair.of((Object)true, itemsThatHandleDamage);
            }
            return Pair.of((Object)false, itemsThatHandleDamage);
        }
        SquatGrowConfig.Requirements requirements = SquatGrow.config.requirements;
        if (requirements.enabled && SquatGrow.computedRequirements != null) {
            List<ItemStack> matchingEquipment;
            if (requirements.heldItemRequirement.isEmpty() && requirements.equipmentRequirement.isEmpty()) {
                return Pair.of((Object)true, itemsThatHandleDamage);
            }
            boolean passesEquipment = false;
            if (!requirements.equipmentRequirement.isEmpty() && (matchingEquipment = SquatAction.matchingEquipmentItem(player.level(), player, SquatGrow.computedRequirements.equipmentRequirementStacks(), SquatGrow.computedRequirements.equipmentRequirementTags())).size() == requirements.equipmentRequirement.size()) {
                itemsThatHandleDamage.addAll(matchingEquipment);
                passesEquipment = true;
            }
            if (!requirements.equipmentRequirement.isEmpty() && !passesEquipment) {
                return Pair.of((Object)false, itemsThatHandleDamage);
            }
            boolean passedHeldItem = false;
            ItemStack matchingHeldItem = SquatAction.getMatchingHeldItem(player, SquatGrow.computedRequirements.heldItemRequirementStacks(), SquatGrow.computedRequirements.heldItemRequirementTags());
            if (!matchingHeldItem.isEmpty()) {
                itemsThatHandleDamage.add(matchingHeldItem);
                passedHeldItem = true;
            }
            if (!requirements.heldItemRequirement.isEmpty() && !passedHeldItem) {
                return Pair.of((Object)false, itemsThatHandleDamage);
            }
            return Pair.of((Object)true, itemsThatHandleDamage);
        }
        return Pair.of((Object)true, Collections.emptyList());
    }

    public static void grow(Level level, ServerPlayer player, List<ItemStack> itemsToDamage) {
        BlockPos pos = player.blockPosition();
        RandomSource r = level.random;
        ImmutableSet<Action> actions = Actions.get().getActions();
        for (int x = -SquatGrow.config.range; x <= SquatGrow.config.range; ++x) {
            for (int z = -SquatGrow.config.range; z <= SquatGrow.config.range; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    double randomValue = 0.0 + 1.0 * r.nextDouble();
                    if ((double)SquatGrow.config.chance < randomValue) continue;
                    boolean didGrow = false;
                    BlockPos offsetLocation = pos.offset(x, y, z);
                    BlockState offsetState = level.getBlockState(offsetLocation);
                    if (offsetState.isAir() || !SquatGrow.allowTwerk(offsetState).booleanValue()) continue;
                    ActionContext context = new ActionContext(level, offsetLocation, offsetState, player.getMainHandItem(), player.getOffhandItem(), (Player)player);
                    for (Action action : actions) {
                        if (!action.canApply(context)) continue;
                        didGrow = action.execute(context);
                    }
                    if ((SquatGrow.config.hoeTakesDamage || SquatGrow.config.requirements.requiredItemTakesDamage) && didGrow && !itemsToDamage.isEmpty()) {
                        int durabilityToApply = SquatGrow.config.hoeTakesDamage ? 1 : SquatGrow.config.requirements.durabilityDamage;
                        for (ItemStack item : itemsToDamage) {
                            item.hurtAndBreak(durabilityToApply, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                        }
                    }
                    if (!didGrow) continue;
                    SquatAction.addGrowthParticles((ServerLevel)level, offsetLocation, player);
                }
            }
        }
    }

    private static void addGrowthParticles(ServerLevel level, BlockPos pos, ServerPlayer player) {
        RandomSource random = level.random;
        int numParticles = 2;
        BlockState blockstate = level.getBlockState(pos);
        if (!blockstate.isAir()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.is(Blocks.WATER)) {
                numParticles *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.isSolidRender((BlockGetter)level, pos)) {
                pos = pos.above();
                numParticles *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.getShape((BlockGetter)level, pos).max(Direction.Axis.Y);
            }
            int randomPartialCount = random.nextInt(1, numParticles);
            BlockPos immutablePos = pos.immutable();
            for (int i = 0; i < randomPartialCount; ++i) {
                double d2 = random.nextGaussian() * 0.2;
                double d3 = random.nextGaussian() * 0.2;
                double d4 = random.nextGaussian() * 0.2;
                double randomY = Mth.clamp((double)random.nextDouble(), (double)0.1, (double)0.5);
                double x = (double)immutablePos.getX() + Mth.clamp((double)random.nextDouble(), (double)-1.0, (double)1.0);
                double y = (double)immutablePos.getY() - 0.95 + (d1 + randomY);
                double z = (double)immutablePos.getZ() + Mth.clamp((double)random.nextDouble(), (double)-1.0, (double)1.0);
                BlockState state = level.getBlockState(immutablePos);
                if (state.isAir()) continue;
                level.sendParticles(player, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, false, x, y, z, numParticles, d2, d3, d4, 0.5);
            }
            level.playSound(null, immutablePos, SoundEvents.BONE_MEAL_USE, SoundSource.MASTER, 0.5f, 1.0f);
        }
    }

    private static ItemStack getMatchingHeldItem(Player player, List<ItemStack> itemStacks, List<TagKey<Item>> itemTags) {
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        ItemStack matchingItem = SquatAction.compareItemToLists(player.level(), mainHand, itemStacks, itemTags);
        if (!matchingItem.isEmpty()) {
            return matchingItem;
        }
        return SquatAction.compareItemToLists(player.level(), offHand, itemStacks, itemTags);
    }

    private static ItemStack compareItemToLists(Level level, ItemStack stack, List<ItemStack> itemStacks, List<TagKey<Item>> itemTags) {
        for (ItemStack itemStack : itemStacks) {
            if (!SquatAction.itemStackMatches(level, stack, itemStack)) continue;
            return stack;
        }
        for (TagKey tagKey : itemTags) {
            if (!SquatAction.itemStackMatches(level, stack, (TagKey<Item>)tagKey)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static List<ItemStack> matchingEquipmentItem(Level level, Player player, Map<EquipmentSlot, ItemStack> equipmentStacks, Map<EquipmentSlot, TagKey<Item>> equipmentTags) {
        ItemStack itemBySlot;
        ArrayList<ItemStack> matchedItems = new ArrayList<ItemStack>();
        for (Map.Entry<EquipmentSlot, ItemStack> entry : equipmentStacks.entrySet()) {
            itemBySlot = player.getItemBySlot(entry.getKey());
            if (!SquatAction.itemStackMatches(level, itemBySlot, entry.getValue())) continue;
            matchedItems.add(itemBySlot);
        }
        for (Map.Entry<EquipmentSlot, ItemStack> entry : equipmentTags.entrySet()) {
            itemBySlot = player.getItemBySlot(entry.getKey());
            if (!SquatAction.itemStackMatches(level, itemBySlot, (TagKey<Item>)((TagKey)entry.getValue()))) continue;
            matchedItems.add(itemBySlot);
        }
        return matchedItems;
    }

    private static boolean itemStackMatches(Level level, ItemStack stack, TagKey<Item> tag) {
        ItemEnchantments itemEnchantments;
        Enchantment enchantmentValue;
        if (SquatGrow.computedEnchantment != null && stack.isEnchantable() && (enchantmentValue = SquatGrow.computedEnchantment.get((LevelAccessor)level)) != null && stack.is(tag) && (itemEnchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null) {
            return stack.is(tag) && itemEnchantments.getLevel(Holder.direct((Object)enchantmentValue)) > 0;
        }
        return stack.is(tag);
    }

    private static boolean itemStackMatches(Level level, ItemStack stack, ItemStack item) {
        ItemEnchantments itemEnchantments;
        Enchantment enchantmentValue;
        if (SquatGrow.computedEnchantment != null && stack.isEnchantable() && (enchantmentValue = SquatGrow.computedEnchantment.get((LevelAccessor)level)) != null && stack.is(item.getItem()) && (itemEnchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null) {
            return itemEnchantments.getLevel(Holder.direct((Object)enchantmentValue)) > 0;
        }
        return stack.is(item.getItem());
    }
}

