/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.common.entity.ai.FireCannonGoal;
import alexthw.ars_elemental.common.glyphs.EffectConflagrate;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.alexthw.sauce.api.item.ISchoolProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.items.data.ICharmSerializable;
import com.hollingsworth.arsnouveau.common.items.data.PersistentFamiliarData;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.nuggets.client.overlay.IWorldTooltipProvider;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FirenandoEntity
extends PathfinderMob
implements ISchoolProvider,
RangedAttackMob,
GeoEntity,
IWorldTooltipProvider,
IAnimationListener,
IWandable,
IDispellable,
ICharmSerializable {
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle.body");
    private final RawAnimation inactive = RawAnimation.begin().thenPlayAndHold("inactive");
    private final RawAnimation mainIdle = RawAnimation.begin().thenLoop("idle");
    private int castCooldown = 0;
    private final ParticleColor color = new ParticleColor(250, 50, 15);
    private final ParticleColor colorAlt = new ParticleColor(15, 100, 200);
    public final Spell spell = new Spell(new AbstractSpellPart[]{MethodHomingProjectile.INSTANCE, EffectIgnite.INSTANCE, AugmentSensitive.INSTANCE, EffectConflagrate.INSTANCE, AugmentAmplify.INSTANCE, EffectKnockback.INSTANCE});
    public UUID owner;
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.defineId(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.defineId(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.defineId(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    AnimationController<FirenandoEntity> attackController;

    public FirenandoEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public FirenandoEntity(Level world) {
        super((EntityType)ModEntities.FIRENANDO_ENTITY.get(), world);
    }

    public boolean isAlliedTo(@NotNull Entity pEntity) {
        return !(pEntity instanceof Enemy) || super.isAlliedTo(pEntity);
    }

    public void tick() {
        super.tick();
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
        if (!this.level().isClientSide() && this.level().getGameTime() % 20L == 0L && this.isActive() && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
        }
        if (!this.level().isClientSide() && this.level().getGameTime() % 100L == 0L && !this.isActive() && this.getHealth() < this.getMaxHealth()) {
            this.heal(1.0f);
            if (this.getHealth() >= this.getMaxHealth()) {
                this.entityData.set(ACTIVE, (Object)true);
            }
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (source.is(DamageTypes.CACTUS) || source.is(DamageTypes.SWEET_BERRY_BUSH) || source.is(DamageTypeTags.IS_FIRE)) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean isNoAi() {
        return super.isNoAi() || !this.isActive();
    }

    public void die(@NotNull DamageSource source) {
        if (!this.level().isClientSide && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.entityData.set(ACTIVE, (Object)false);
            if (source.getEntity() != null) {
                if (((Boolean)ConfigHandler.Common.FIRENANDO_KILL.get()).booleanValue() && source.getEntity().getUUID().equals(this.getOwner())) {
                    this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)ModItems.FIRENANDO_CHARM.get())));
                    super.die(source);
                    return;
                }
                Entity entity = source.getEntity();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.setTarget(null);
                }
            }
            this.setHealth(0.1f);
            return;
        }
        super.die(source);
    }

    public void fromCharmData(PersistentFamiliarData data) {
        this.setColor(data.color());
        this.setCustomName(data.name());
    }

    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved() || this.level().isClientSide) {
            return false;
        }
        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)ModItems.FIRENANDO_CHARM.get())));
        ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level()), (BlockPos)this.blockPosition());
        this.remove(Entity.RemovalReason.DISCARDED);
        return true;
    }

    public void performRangedAttack(@NotNull LivingEntity target, float pVelocity) {
        ParticleColor spellColor = this.getColor().equals(Variants.MAGMA.toString()) ? this.color : this.colorAlt;
        EntitySpellResolver resolver = new EntitySpellResolver(this, new SpellContext(this.level(), this.spell, (LivingEntity)this, (IWrappedCaster)new LivingCaster((LivingEntity)this)).withColors(spellColor)){

            public boolean hasFocus(Item stack) {
                return stack == ModItems.FIRE_FOCUS.get();
            }
        };
        EntityHomingProjectileSpell projectileSpell = new EntityHomingProjectileSpell(this.level(), (SpellResolver)resolver);
        List<Predicate<LivingEntity>> ignore = MethodHomingProjectile.basicIgnores((LivingEntity)this, false, resolver.spell);
        ignore.add(entity -> !(entity instanceof Enemy));
        ignore.add(entity -> {
            if (!(entity instanceof FirenandoEntity)) return false;
            FirenandoEntity firenando = (FirenandoEntity)((Object)entity);
            if (!this.getOwner().equals(firenando.getOwner())) return false;
            return true;
        });
        projectileSpell.shoot((Entity)this, this.getXRot(), this.getYRot(), 0.0f, 0.8f, 0.8f);
        projectileSpell.setIgnored(ignore);
        this.level().addFreshEntity((Entity)projectileSpell);
        this.castCooldown = 20;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 12, () -> this.getTarget() == null));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, false, entity -> entity instanceof Enemy));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new FireCannonGoal(this, 0.8, 20, 55.0f, () -> this.castCooldown <= 0 && this.isActive(), Animations.SHOOT.ordinal(), 20));
    }

    public boolean removeWhenFarAway(double p_213397_1_) {
        return false;
    }

    protected int getBaseExperienceReward() {
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.ARMOR, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.setHome(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.home_set"));
        }
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(ACTIVE);
    }

    public void setHome(BlockPos home) {
        this.entityData.set(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.entityData.get(HOME)).orElse(null);
    }

    public UUID getOwner() {
        return this.owner;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOTING, (Object)false);
        builder.define(ACTIVE, (Object)true);
        builder.define(HOME, Optional.empty());
        builder.define(COLOR, (Object)Variants.MAGMA.toString());
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        NBTUtil.storeBlockPos((CompoundTag)tag, (String)"home", (BlockPos)this.getHome());
        tag.putInt("cast", this.castCooldown);
        tag.putBoolean("active", ((Boolean)this.entityData.get(ACTIVE)).booleanValue());
        tag.putString("color", (String)this.entityData.get(COLOR));
        if (this.owner != null) {
            tag.putUUID("owner", this.owner);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (NBTUtil.hasBlockPos((CompoundTag)tag, (String)"home")) {
            this.setHome(NBTUtil.getNullablePos((CompoundTag)tag, (String)"home"));
        }
        this.castCooldown = tag.getInt("cast");
        this.entityData.set(ACTIVE, (Object)tag.getBoolean("active"));
        this.entityData.set(COLOR, (Object)tag.getString("color"));
        this.owner = tag.hasUUID("owner") ? tag.getUUID("owner") : null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "idle_controller", 5, event -> this.isActive() ? event.setAndContinue(this.idle) : event.setAndContinue(this.inactive)));
        this.attackController = new AnimationController((GeoAnimatable)this, "attack_controller", 1, this::attackPredicate);
        data.add(this.attackController);
    }

    PlayState attackPredicate(AnimationState<FirenandoEntity> event) {
        if (!this.isActive()) {
            return PlayState.STOP;
        }
        if (this.attackController.getCurrentAnimation() == null) {
            return event.setAndContinue(this.mainIdle);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void startAnimation(int arg) {
        if (arg == Animations.SHOOT.ordinal() && this.attackController != null) {
            if (this.attackController.getCurrentAnimation() != null && this.attackController.getCurrentAnimation().animation().name().equals("shoot")) {
                return;
            }
            this.attackController.forceAnimationReset();
            this.attackController.setAnimation(RawAnimation.begin().thenPlay("shoot").thenLoop("idle"));
        }
    }

    public void setOwner(Player player) {
        this.owner = player.getUUID();
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.getHome() != null) {
            String home = this.getHome().getX() + ", " + this.getHome().getY() + ", " + this.getHome().getZ();
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{home}));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{Component.translatable((String)"ars_nouveau.nothing").getString()}));
        }
    }

    public SpellSchool getSchool() {
        return SpellSchools.ELEMENTAL_FIRE;
    }

    public String getColor() {
        return (String)this.entityData.get(COLOR);
    }

    public void setColor(String color) {
        this.entityData.set(COLOR, (Object)color);
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack stack;
        if (!player.level().isClientSide && player.getUUID().equals(this.owner)) {
            stack = player.getItemInHand(hand);
            if (stack.getItem() == Blocks.MAGMA_BLOCK.asItem() && !this.getColor().equals(Variants.MAGMA.toString())) {
                this.setColor(Variants.MAGMA.toString());
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
            if (stack.getItem() == Blocks.SOUL_SAND.asItem() && !this.getColor().equals(Variants.SOUL.toString())) {
                this.setColor(Variants.SOUL.toString());
                stack.shrink(1);
                return InteractionResult.SUCCESS;
            }
        }
        if (!(player.level().isClientSide() || this.isActive() || (stack = player.getItemInHand(hand)).getItem() != Items.MAGMA_CREAM && stack.getItem() != Items.BLAZE_POWDER)) {
            this.heal(100.0f);
            this.entityData.set(ACTIVE, (Object)true);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public ResourceLocation getTexture() {
        if (!this.isActive()) {
            return ArsElemental.prefix("textures/entity/firenando_inactive.png");
        }
        return ArsElemental.prefix("textures/entity/firenando_" + (this.getColor().isEmpty() ? Variants.MAGMA.toString() : this.getColor()) + ".png");
    }

    public static enum Variants {
        MAGMA,
        SOUL;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Animations {
        SHOOT;

    }
}

