/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.unification.TagInheritance;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class TagConfig
extends Config {
    public static final String NAME = "tags";
    public static final TagSerializer SERIALIZER = new TagSerializer();
    private final Map<ResourceLocation, Set<ResourceLocation>> customTags;
    private final Map<ResourceLocation, Set<ResourceLocation>> tagSubstitutions;
    private final TagInheritance.Mode itemTagInheritanceMode;
    private final Map<TagKey<Item>, Set<Pattern>> itemTagInheritance;
    private final TagInheritance.Mode blockTagInheritanceMode;
    private final Map<TagKey<Block>, Set<Pattern>> blockTagInheritance;
    private final boolean emiStrictHiding;

    private TagConfig(Map<ResourceLocation, Set<ResourceLocation>> customTags, Map<ResourceLocation, Set<ResourceLocation>> tagSubstitutions, TagInheritance.Mode itemTagInheritanceMode, Map<TagKey<Item>, Set<Pattern>> itemTagInheritance, TagInheritance.Mode blockTagInheritanceMode, Map<TagKey<Block>, Set<Pattern>> blockTagInheritance, boolean emiStrictHiding) {
        super(NAME);
        this.customTags = customTags;
        this.tagSubstitutions = tagSubstitutions;
        this.itemTagInheritanceMode = itemTagInheritanceMode;
        this.itemTagInheritance = itemTagInheritance;
        this.blockTagInheritanceMode = blockTagInheritanceMode;
        this.blockTagInheritance = blockTagInheritance;
        this.emiStrictHiding = emiStrictHiding;
    }

    public TagInheritance getTagInheritance() {
        return new TagInheritance(this.itemTagInheritanceMode, this.itemTagInheritance, this.blockTagInheritanceMode, this.blockTagInheritance);
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getCustomTags() {
        return Collections.unmodifiableMap(this.customTags);
    }

    public Map<ResourceLocation, Set<ResourceLocation>> getTagSubstitutions() {
        return Collections.unmodifiableMap(this.tagSubstitutions);
    }

    public boolean isEmiHidingStrict() {
        return this.emiStrictHiding;
    }

    public static final class TagSerializer
    extends Config.Serializer<TagConfig> {
        private static final String CUSTOM_TAGS = "custom_tags";
        private static final String TAG_SUBSTITUTIONS = "tag_substitutions";
        private static final String ITEM_TAG_INHERITANCE_MODE = "item_tag_inheritance_mode";
        private static final String ITEM_TAG_INHERITANCE = "item_tag_inheritance";
        private static final String BLOCK_TAG_INHERITANCE_MODE = "block_tag_inheritance_mode";
        private static final String BLOCK_TAG_INHERITANCE = "block_tag_inheritance";
        private static final String EMI_STRICT_HIDING = "emi_strict_hiding";

        private TagSerializer() {
        }

        @Override
        public TagConfig handleDeserialization(JsonObject json) {
            Map customTags = this.safeGet(() -> JsonUtils.deserializeMapSet(json, CUSTOM_TAGS, e -> ResourceLocation.parse((String)((String)e.getKey())), ResourceLocation::parse), new HashMap());
            Map tagSubstitutions = this.safeGet(() -> JsonUtils.deserializeMapSet(json, TAG_SUBSTITUTIONS, e -> ResourceLocation.parse((String)((String)e.getKey())), ResourceLocation::parse), new HashMap());
            TagInheritance.Mode itemTagInheritanceMode = this.deserializeTagInheritanceMode(json, ITEM_TAG_INHERITANCE_MODE);
            Map<TagKey<Item>, Set<Pattern>> itemTagInheritance = this.deserializePatternsForLocations(Registries.ITEM, json, ITEM_TAG_INHERITANCE);
            TagInheritance.Mode blockTagInheritanceMode = this.deserializeTagInheritanceMode(json, BLOCK_TAG_INHERITANCE_MODE);
            Map<TagKey<Block>, Set<Pattern>> blockTagInheritance = this.deserializePatternsForLocations(Registries.BLOCK, json, BLOCK_TAG_INHERITANCE);
            boolean emiStrictHiding = AlmostUnifiedPlatform.INSTANCE.isModLoaded("emi") ? this.safeGet(() -> json.get(EMI_STRICT_HIDING).getAsBoolean(), true) : false;
            return new TagConfig(customTags, tagSubstitutions, itemTagInheritanceMode, itemTagInheritance, blockTagInheritanceMode, blockTagInheritance, emiStrictHiding);
        }

        @Override
        public JsonObject serialize(TagConfig config) {
            JsonObject json = new JsonObject();
            JsonObject customTags = new JsonObject();
            config.customTags.forEach((parent, child) -> customTags.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(ResourceLocation::toString).toList())));
            json.add(CUSTOM_TAGS, (JsonElement)customTags);
            JsonObject tagSubstitutions = new JsonObject();
            config.tagSubstitutions.forEach((parent, child) -> tagSubstitutions.add(parent.toString(), (JsonElement)JsonUtils.toArray(child.stream().map(ResourceLocation::toString).toList())));
            json.add(TAG_SUBSTITUTIONS, (JsonElement)tagSubstitutions);
            JsonObject itemTagInheritance = new JsonObject();
            config.itemTagInheritance.forEach((tag, patterns) -> itemTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(ITEM_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.itemTagInheritanceMode.toString()));
            json.add(ITEM_TAG_INHERITANCE, (JsonElement)itemTagInheritance);
            JsonObject blockTagInheritance = new JsonObject();
            config.blockTagInheritance.forEach((tag, patterns) -> blockTagInheritance.add(tag.toString(), (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::toString).toList())));
            json.add(BLOCK_TAG_INHERITANCE_MODE, (JsonElement)new JsonPrimitive(config.blockTagInheritanceMode.toString()));
            json.add(BLOCK_TAG_INHERITANCE, (JsonElement)blockTagInheritance);
            if (AlmostUnifiedPlatform.INSTANCE.isModLoaded("emi")) {
                json.addProperty(EMI_STRICT_HIDING, Boolean.valueOf(config.emiStrictHiding));
            }
            return json;
        }

        private <T> Map<TagKey<T>, Set<Pattern>> unsafeDeserializePatternsForLocations(ResourceKey<Registry<T>> registry, JsonObject rawConfigJson, String baseKey) {
            return JsonUtils.deserializeMapSet(rawConfigJson, baseKey, e -> TagKey.create((ResourceKey)registry, (ResourceLocation)ResourceLocation.parse((String)((String)e.getKey()))), Pattern::compile);
        }

        private <T> Map<TagKey<T>, Set<Pattern>> deserializePatternsForLocations(ResourceKey<Registry<T>> registry, JsonObject rawConfigJson, String baseKey) {
            return this.safeGet(() -> this.unsafeDeserializePatternsForLocations(registry, rawConfigJson, baseKey), new HashMap());
        }

        private TagInheritance.Mode deserializeTagInheritanceMode(JsonObject json, String key) {
            return this.safeGet(() -> TagInheritance.Mode.valueOf(json.getAsJsonPrimitive(key).getAsString().toUpperCase()), TagInheritance.Mode.ALLOW);
        }
    }
}

