/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.unification;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class IntegratedDynamicsRecipeUnifier
implements RecipeUnifier {
    private static final String ITEMS = "items";

    @Override
    public void unify(UnificationHelper helper, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unify(helper, recipe);
        IntegratedDynamicsRecipeUnifier.unifyItemInput(helper, recipe);
        helper.unifyOutputs(recipe, "result", true, ITEMS);
        this.unifyItemResult(helper, recipe);
    }

    private static void unifyItemInput(UnificationHelper helper, RecipeJson recipe) {
        JsonElement element = recipe.getProperty("item");
        if (element instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)element;
            JsonObject itemAsObject = new JsonObject();
            itemAsObject.add("item", (JsonElement)primitive);
            if (helper.unifyInputElement((JsonElement)itemAsObject, new String[0])) {
                recipe.setProperty("item", (JsonElement)itemAsObject);
                return;
            }
        }
        helper.unifyInputs(recipe, "item");
    }

    private void unifyItemResult(UnificationHelper helper, RecipeJson recipe) {
        JsonElement element = recipe.getProperty("result");
        if (!(element instanceof JsonObject)) {
            return;
        }
        JsonObject result = (JsonObject)element;
        JsonElement itemsElement = result.get(ITEMS);
        if (!(itemsElement instanceof JsonArray)) {
            return;
        }
        JsonArray items = (JsonArray)itemsElement;
        helper.unifyOutputArray(items, true, "item");
    }
}

