/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.mixin;

import com.google.common.collect.Maps;
import dev.uncandango.kubejstweaks.KubeJSTweaks;
import dev.uncandango.kubejstweaks.mixin.annotation.ConditionalMixin;
import dev.uncandango.kubejstweaks.mixin.annotation.Helper;
import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public class ConditionalMixinManager {
    private Map<String, Boolean> conditionalMixins = Maps.newHashMap();

    public ConditionalMixinManager() {
        ModFileScanData scanData = LoadingModList.get().getModFileById("kubejstweaks").getFile().getScanResult();
        scanData.getAnnotatedBy(ConditionalMixin.class, ElementType.TYPE).forEach(annotation -> {
            Boolean shouldLoad;
            String currentMixin;
            block12: {
                currentMixin = annotation.memberName();
                shouldLoad = null;
                String modId = (String)Helper.getValue(annotation, "modId");
                String versionRange = (String)Helper.getValue(annotation, "versionRange");
                List extraModDep = (List)Helper.getValue(annotation, "extraModDep");
                List extraModDepVersions = (List)Helper.getValue(annotation, "extraModDepVersions");
                String config = (String)Helper.getValue(annotation, "config");
                Boolean devOnly = (Boolean)Helper.getValue(annotation, "devOnly");
                ModFileInfo mod = LoadingModList.get().getModFileById(modId);
                if (Boolean.TRUE.equals(devOnly) && FMLEnvironment.production) {
                    KubeJSTweaks.LOGGER.info("Conditional Mixin {} will not be loaded in production", (Object)currentMixin);
                    shouldLoad = false;
                }
                if (mod != null && shouldLoad == null) {
                    try {
                        VersionRange range = VersionRange.createFromVersionSpec((String)versionRange);
                        String modVerString = mod.versionString();
                        DefaultArtifactVersion modVer = new DefaultArtifactVersion(modVerString);
                        if (range != null && range.containsVersion((ArtifactVersion)modVer) || modVerString.equals("0.0NONE")) {
                            if (!extraModDep.isEmpty()) {
                                for (int i = 0; i < extraModDep.size(); ++i) {
                                    String depVerString;
                                    DefaultArtifactVersion depVer;
                                    ModFileInfo dep = LoadingModList.get().getModFileById((String)extraModDep.get(i));
                                    if (dep == null) {
                                        KubeJSTweaks.LOGGER.debug("Extra dependency Mod {} is not present in the mod list", extraModDep.get(i));
                                        KubeJSTweaks.LOGGER.debug("Class {} will NOT be loaded as extra mod dependecy is not present.", (Object)annotation.memberName());
                                        shouldLoad = false;
                                        continue;
                                    }
                                    VersionRange rangeDepVer = VersionRange.createFromVersionSpec((String)((String)extraModDepVersions.get(i)));
                                    if (rangeDepVer.containsVersion((ArtifactVersion)(depVer = new DefaultArtifactVersion(depVerString = dep.versionString()))) || depVerString.equals("0.0NONE")) {
                                        KubeJSTweaks.LOGGER.info("Extra dependecy Mod {} matches versions: {} in {}", new Object[]{extraModDep.get(i), dep.versionString(), extraModDepVersions.get(i)});
                                        continue;
                                    }
                                    KubeJSTweaks.LOGGER.debug("Extra dependecy Mod {} does NOT matches versions: {} in {}", new Object[]{extraModDep.get(i), dep.versionString(), extraModDepVersions.get(i)});
                                    KubeJSTweaks.LOGGER.debug("Class {} will NOT be loaded as extra mod dependecy does not match.", (Object)annotation.memberName());
                                    shouldLoad = false;
                                }
                                if (shouldLoad == null) {
                                    KubeJSTweaks.LOGGER.info("Conditional Mixin {} will be loaded as it matches versions: {} in {}", new Object[]{currentMixin, modVer, range});
                                    shouldLoad = true;
                                }
                            } else {
                                KubeJSTweaks.LOGGER.info("Conditional Mixin {} will be loaded as it matches versions: {} in {}", new Object[]{currentMixin, modVer, range});
                                shouldLoad = true;
                            }
                            break block12;
                        }
                        shouldLoad = false;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        KubeJSTweaks.LOGGER.error("Conditional Mixin {} with Invalid Version Spec {}", (Object)currentMixin, (Object)versionRange);
                        shouldLoad = false;
                    }
                } else {
                    KubeJSTweaks.LOGGER.debug("Conditional Mixin {} with Mod {} not found", (Object)currentMixin, (Object)modId);
                }
            }
            this.conditionalMixins.put(currentMixin, shouldLoad != null && shouldLoad != false);
        });
    }

    public boolean shouldLoad(String mixinClassName) {
        return this.conditionalMixins.getOrDefault(mixinClassName, true);
    }
}

