/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.util;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XYMap<V>
implements Map<String, V> {
    private static final ImmutableSet<String> KEYS = ImmutableSet.of((Object)"x", (Object)"y");
    V x;
    V y;

    XYMap(V x, V y) {
        this.x = x;
        this.y = y;
    }

    public static <V> XYMap<V> of(V x, V y, V z) {
        return new XYMap<V>(x, y);
    }

    public static XYMap<Float> of(Vec2 vec) {
        return new XYMap<Float>(Float.valueOf(vec.x), Float.valueOf(vec.y));
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof String && (key.equals("x") || key.equals("y"));
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            String s;
            return switch (s = (String)key) {
                case "x" -> this.x;
                case "y" -> this.y;
                default -> throw new UnsupportedOperationException();
            };
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public V put(String key, V value) {
        switch (key) {
            case "x": {
                this.x = value;
                break;
            }
            case "y": {
                this.y = value;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return KEYS;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return List.of(this.x, this.y);
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, V>> entrySet() {
        return Set.of(new XEntry(this), new YEntry(this));
    }

    public V getX() {
        return this.x;
    }

    public V getY() {
        return this.y;
    }

    public void setX(V x) {
        this.x = x;
    }

    public void setY(V y) {
        this.y = y;
    }

    public static class XEntry<V>
    implements Map.Entry<String, V> {
        XYMap<V> map;

        public XEntry(XYMap<V> map) {
            this.map = map;
        }

        @Override
        public String getKey() {
            return "x";
        }

        @Override
        public V getValue() {
            return this.map.getX();
        }

        @Override
        public V setValue(V value) {
            this.map.setX(value);
            return value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof XEntry)) return false;
            XEntry other = (XEntry)o;
            if (!other.map.equals(this.map)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }

    public static class YEntry<V>
    implements Map.Entry<String, V> {
        XYMap<V> map;

        public YEntry(XYMap<V> map) {
            this.map = map;
        }

        @Override
        public String getKey() {
            return "y";
        }

        @Override
        public V getValue() {
            return this.map.getY();
        }

        @Override
        public V setValue(V value) {
            this.map.setY(value);
            return value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof YEntry)) return false;
            YEntry other = (YEntry)o;
            if (!other.map.equals(this.map)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.map.hashCode() + 1;
        }
    }
}

