/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.registry;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.setup.registry.BlockEntityTypeRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import dev.qther.ars_controle.block.ScrollHolderBlock;
import dev.qther.ars_controle.block.ScryersLinkageBlock;
import dev.qther.ars_controle.block.TemporalStabilitySensorBlock;
import dev.qther.ars_controle.block.WarpingSpellPrismBlock;
import dev.qther.ars_controle.block.tile.ScrollHolderTile;
import dev.qther.ars_controle.block.tile.ScryersLinkageTile;
import dev.qther.ars_controle.block.tile.WarpingSpellPrismTile;
import dev.qther.ars_controle.item.PortableBrazierRelayItem;
import dev.qther.ars_controle.item.RemoteItem;
import dev.qther.ars_controle.spell.effect.EffectPreciseDelay;
import dev.qther.ars_controle.spell.filter.FilterBinary;
import dev.qther.ars_controle.spell.filter.FilterRandom;
import dev.qther.ars_controle.spell.filter.FilterUnary;
import dev.qther.ars_controle.spell.filter.FilterYLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ACRegistry {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"ars_controle");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"ars_controle");
    public static final DeferredRegister<DataComponentType<?>> DATA = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"ars_controle");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"ars_controle");
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ars_controle");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"ars_controle");

    public static void register(IEventBus bus) {
        Blocks.register(bus);
        Tiles.register(bus);
        Items.register(bus);
        Tabs.register(bus);
        Components.register(bus);
        Attachments.register(bus);
        Glyphs.registerAll();
    }

    public static class Blocks {
        public static BlockRegistryWrapper<WarpingSpellPrismBlock> WARPING_SPELL_PRISM = new BlockRegistryWrapper(BLOCKS.register("warping_spell_prism", block -> new WarpingSpellPrismBlock()));
        public static BlockRegistryWrapper<ScryersLinkageBlock> SCRYERS_LINKAGE = new BlockRegistryWrapper(BLOCKS.register("scryers_linkage", block -> new ScryersLinkageBlock()));
        public static BlockRegistryWrapper<ScrollHolderBlock> SCROLL_HOLDER = new BlockRegistryWrapper(BLOCKS.register("scroll_holder", block -> new ScrollHolderBlock()));
        public static BlockRegistryWrapper<TemporalStabilitySensorBlock> TEMPORAL_STABILITY_SENSOR = new BlockRegistryWrapper(BLOCKS.register("temporal_stability_sensor", block -> new TemporalStabilitySensorBlock()));

        public static void register(IEventBus bus) {
            BLOCKS.register(bus);
        }
    }

    public static class Tiles {
        public static BlockEntityTypeRegistryWrapper<WarpingSpellPrismTile> WARPING_SPELL_PRISM = new BlockEntityTypeRegistryWrapper(TILES.register("warping_spell_prism", () -> BlockEntityType.Builder.of(WarpingSpellPrismTile::new, (Block[])new Block[]{(Block)Blocks.WARPING_SPELL_PRISM.get()}).build(null)));
        public static BlockEntityTypeRegistryWrapper<ScryersLinkageTile> SCRYERS_LINKAGE = new BlockEntityTypeRegistryWrapper(TILES.register("scryers_linkage", () -> BlockEntityType.Builder.of(ScryersLinkageTile::new, (Block[])new Block[]{(Block)Blocks.SCRYERS_LINKAGE.get()}).build(null)));
        public static BlockEntityTypeRegistryWrapper<ScrollHolderTile> SCROLL_HOLDER = new BlockEntityTypeRegistryWrapper(TILES.register("scroll_holder", () -> BlockEntityType.Builder.of(ScrollHolderTile::new, (Block[])new Block[]{(Block)Blocks.SCROLL_HOLDER.get()}).build(null)));

        public static void register(IEventBus bus) {
            TILES.register(bus);
        }
    }

    public static class Items {
        public static ItemRegistryWrapper<Item> WARPING_SPELL_PRISM = new ItemRegistryWrapper(ITEMS.register("warping_spell_prism", () -> BlockRegistry.getDefaultBlockItem((Block)((Block)Blocks.WARPING_SPELL_PRISM.get()))));
        public static ItemRegistryWrapper<Item> SCRYERS_LINKAGE = new ItemRegistryWrapper(ITEMS.register("scryers_linkage", () -> BlockRegistry.getDefaultBlockItem((Block)((Block)Blocks.SCRYERS_LINKAGE.get()))));
        public static ItemRegistryWrapper<Item> SCROLL_HOLDER = new ItemRegistryWrapper(ITEMS.register("scroll_holder", () -> BlockRegistry.getDefaultBlockItem((Block)((Block)Blocks.SCROLL_HOLDER.get()))));
        public static ItemRegistryWrapper<Item> TEMPORAL_STABILITY_SENSOR = new ItemRegistryWrapper(ITEMS.register("temporal_stability_sensor", () -> BlockRegistry.getDefaultBlockItem((Block)((Block)Blocks.TEMPORAL_STABILITY_SENSOR.get()))));
        public static ItemRegistryWrapper<Item> REMOTE = new ItemRegistryWrapper(ITEMS.register("remote", RemoteItem::new));
        public static ItemRegistryWrapper<Item> PORTABLE_BRAZIER_RELAY = new ItemRegistryWrapper(ITEMS.register("portable_brazier_relay", PortableBrazierRelayItem::new));

        public static void register(IEventBus bus) {
            ITEMS.register(bus);
        }
    }

    public static class Tabs {
        public static DeferredHolder<CreativeModeTab, CreativeModeTab> MAIN = TABS.register("general", () -> CreativeModeTab.builder().title((Component)Component.literal((String)"Ars Controle")).icon(() -> ((Item)Items.REMOTE.get()).getDefaultInstance()).displayItems((params, output) -> {
            for (DeferredHolder entry : ITEMS.getEntries()) {
                output.accept(((Item)entry.get()).getDefaultInstance());
            }
        }).build());

        public static void register(IEventBus bus) {
            TABS.register(bus);
        }
    }

    public static class Components {
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<RemoteItem.RemoteData>> REMOTE = DATA.register("remote_data", () -> DataComponentType.builder().persistent(RemoteItem.RemoteData.CODEC).networkSynchronized(RemoteItem.RemoteData.STREAM_CODEC).build());
        public static final DeferredHolder<DataComponentType<?>, DataComponentType<PortableBrazierRelayItem.PortableBrazierRelayData>> PORTABLE_BRAZIER_RELAY = DATA.register("portable_brazier", () -> DataComponentType.builder().persistent(PortableBrazierRelayItem.PortableBrazierRelayData.CODEC).networkSynchronized(PortableBrazierRelayItem.PortableBrazierRelayData.STREAM_CODEC).build());

        public static void register(IEventBus bus) {
            DATA.register(bus);
        }
    }

    public static class Attachments {
        public static final Supplier<AttachmentType<UUID>> RELAY_UUID = ATTACHMENT_TYPES.register("relay_uuid", () -> AttachmentType.builder(() -> new UUID(0L, 0L)).serialize(UUIDUtil.CODEC).build());
        public static final Supplier<AttachmentType<UUID>> ASSOCIATION = ATTACHMENT_TYPES.register("association", () -> AttachmentType.builder(() -> new UUID(0L, 0L)).serialize(UUIDUtil.CODEC).build());
        public static final Supplier<AttachmentType<GlobalPos>> GLOBAL_POS_TARGET = ATTACHMENT_TYPES.register("block_target", () -> AttachmentType.builder(() -> {
            throw new UnsupportedOperationException();
        }).serialize(GlobalPos.CODEC).build());
        public static final Supplier<AttachmentType<UUID>> ENTITY_TARGET = ATTACHMENT_TYPES.register("entity_target", () -> AttachmentType.builder(() -> {
            throw new UnsupportedOperationException();
        }).serialize(UUIDUtil.CODEC).build());

        public static void register(IEventBus bus) {
            ATTACHMENT_TYPES.register(bus);
        }
    }

    public static class Glyphs {
        public static List<AbstractSpellPart> registeredSpells = new ArrayList<AbstractSpellPart>();

        public static void registerAll() {
            Effects.PRECISE_DELAY = Glyphs.register((AbstractSpellPart)EffectPreciseDelay.INSTANCE);
            Filters.ABOVE = Glyphs.register((AbstractSpellPart)FilterYLevel.ABOVE);
            Filters.BELOW = Glyphs.register((AbstractSpellPart)FilterYLevel.BELOW);
            Filters.LEVEL = Glyphs.register((AbstractSpellPart)FilterYLevel.LEVEL);
            Filters.OR = Glyphs.register((AbstractSpellPart)FilterBinary.OR);
            Filters.XOR = Glyphs.register((AbstractSpellPart)FilterBinary.XOR);
            Filters.XNOR = Glyphs.register((AbstractSpellPart)FilterBinary.XNOR);
            Filters.NOT = Glyphs.register((AbstractSpellPart)FilterUnary.NOT);
            Filters.RANDOM = Glyphs.register((AbstractSpellPart)FilterRandom.INSTANCE);
        }

        public static AbstractSpellPart register(AbstractSpellPart spellPart) {
            GlyphRegistry.registerSpell((AbstractSpellPart)spellPart);
            registeredSpells.add(spellPart);
            return spellPart;
        }

        public static class Effects {
            public static AbstractSpellPart PRECISE_DELAY;
        }

        public static class Filters {
            public static AbstractSpellPart ABOVE;
            public static AbstractSpellPart BELOW;
            public static AbstractSpellPart LEVEL;
            public static AbstractSpellPart OR;
            public static AbstractSpellPart XOR;
            public static AbstractSpellPart XNOR;
            public static AbstractSpellPart NOT;
            public static AbstractSpellPart RANDOM;
        }
    }
}

