/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.registry;

import com.hollingsworth.arsnouveau.api.documentation.DocCategory;
import com.hollingsworth.arsnouveau.api.documentation.ReloadDocumentationEvent;
import com.hollingsworth.arsnouveau.api.documentation.builder.DocEntryBuilder;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.Documentation;
import com.hollingsworth.arsnouveau.setup.registry.ItemRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.registry.ACRegistry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class ACDocumentation {
    @SubscribeEvent
    public static void addPages(ReloadDocumentationEvent.AddEntries event) {
        ACDocumentation.addPage(EntryBuilder.of(DocumentationRegistry.CRAFTING, ACRegistry.Blocks.WARPING_SPELL_PRISM).withIcon((ItemLike)ACRegistry.Blocks.WARPING_SPELL_PRISM).withIntroPage().withCraftingPages(ACRegistry.Blocks.WARPING_SPELL_PRISM)).withRelation(ACDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.SPELL_PRISM));
        ACDocumentation.addPage(EntryBuilder.of(DocumentationRegistry.CRAFTING, ACRegistry.Blocks.SCRYERS_LINKAGE).withIcon((ItemLike)ACRegistry.Blocks.SCRYERS_LINKAGE).withIntroPage().withCraftingPages(ACRegistry.Blocks.SCRYERS_LINKAGE));
        ACDocumentation.addPage(EntryBuilder.of(DocumentationRegistry.CRAFTING, ACRegistry.Blocks.TEMPORAL_STABILITY_SENSOR).withIcon((ItemLike)ACRegistry.Blocks.TEMPORAL_STABILITY_SENSOR).withIntroPage().withCraftingPages(ACRegistry.Blocks.TEMPORAL_STABILITY_SENSOR));
        ACDocumentation.addPage(EntryBuilder.of(DocumentationRegistry.CRAFTING, ACRegistry.Items.SCROLL_HOLDER).withIcon((ItemLike)ACRegistry.Items.SCROLL_HOLDER).withIntroPage().withCraftingPages(ACRegistry.Items.SCROLL_HOLDER)).withRelations(new DocEntry[]{ACDocumentation.item((ItemRegistryWrapper<? extends Item>)ItemsRegistry.WARP_SCROLL), ACDocumentation.item((ItemRegistryWrapper<? extends Item>)ItemsRegistry.STABLE_WARP_SCROLL)});
        ACDocumentation.addPage(EntryBuilder.of(DocumentationRegistry.CRAFTING, ACRegistry.Items.REMOTE).withIcon((ItemLike)ACRegistry.Items.REMOTE).withIntroPage().withLocalizedText().withCraftingPages(ACRegistry.Items.REMOTE)).withRelation(ACDocumentation.item((ItemRegistryWrapper<? extends Item>)ItemsRegistry.DOMINION_ROD));
        ACDocumentation.addPage(EntryBuilder.of(DocumentationRegistry.ITEMS, ACRegistry.Items.PORTABLE_BRAZIER_RELAY).withIcon((ItemLike)ACRegistry.Items.PORTABLE_BRAZIER_RELAY).withIntroPage().withCraftingPages(ACRegistry.Items.PORTABLE_BRAZIER_RELAY)).withRelations(new DocEntry[]{ACDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.RITUAL_BLOCK), ACDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.BRAZIER_RELAY)}).withSearchTag((Component)Component.translatable((String)"ars_nouveau.keyword.ritual"));
    }

    @SubscribeEvent
    public static void editPages(ReloadDocumentationEvent.Post event) {
        ACDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.SPELL_PRISM).withRelation(ACDocumentation.block(ACRegistry.Blocks.WARPING_SPELL_PRISM));
        ACDocumentation.item((ItemRegistryWrapper<? extends Item>)ItemsRegistry.DOMINION_ROD).withRelation(ACDocumentation.item(ACRegistry.Items.REMOTE));
        ACDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.RITUAL_BLOCK).withRelation(ACDocumentation.item(ACRegistry.Items.PORTABLE_BRAZIER_RELAY));
        ACDocumentation.block((BlockRegistryWrapper<? extends Block>)BlockRegistry.BRAZIER_RELAY).withRelation(ACDocumentation.item(ACRegistry.Items.PORTABLE_BRAZIER_RELAY));
    }

    private static DocEntry block(BlockRegistryWrapper<? extends Block> block) {
        return DocumentationRegistry.getEntry((ResourceLocation)block.getResourceLocation().withPath(((Block)block.get()).getDescriptionId()));
    }

    private static DocEntry item(ItemRegistryWrapper<? extends Item> item) {
        return DocumentationRegistry.getEntry((ResourceLocation)item.getResourceLocation().withPath(((Item)item.get()).getDescriptionId()));
    }

    private static DocEntry addPage(DocEntryBuilder builder) {
        return DocumentationRegistry.registerEntry((DocCategory)builder.category, (DocEntry)builder.build());
    }

    static class EntryBuilder
    extends DocEntryBuilder {
        public static EntryBuilder of(DocCategory category, String name) {
            return EntryBuilder.of(category, name, ArsControle.prefix(name));
        }

        public static EntryBuilder of(DocCategory category, String name, ResourceLocation entryId) {
            return new EntryBuilder(category, (String)(name.contains(".") ? name : "ars_controle.page." + name), entryId);
        }

        public static EntryBuilder of(DocCategory category, ItemRegistryWrapper<? extends Item> item) {
            return EntryBuilder.of(category, ((Item)item.get()).getDescriptionId());
        }

        public static EntryBuilder of(AbstractSpellPart glyph) {
            return EntryBuilder.of(Documentation.glyphCategory((SpellTier)glyph.getConfigTier()), glyph.getRegistryName().getPath());
        }

        public static EntryBuilder of(DocCategory category, BlockRegistryWrapper<? extends Block> block) {
            return EntryBuilder.of(category, ((Block)block.get()).getDescriptionId());
        }

        private EntryBuilder(DocCategory category, String name, ResourceLocation entryId) {
            super(category, (String)(name.contains(".") ? name : "ars_controle.page." + name), entryId);
        }

        private EntryBuilder(DocCategory category, ItemLike itemLike) {
            super(category, itemLike);
        }
    }
}

