/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.packets.clientbound;

import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import dev.qther.ars_controle.ArsControle;
import dev.qther.ars_controle.registry.ACRegistry;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public final class PacketSyncAssociation
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSyncAssociation> TYPE = new CustomPacketPayload.Type(ArsControle.prefix("sync_association"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncAssociation> CODEC = StreamCodec.ofMember(PacketSyncAssociation::toBytes, PacketSyncAssociation::new);
    private final GlobalPos pos;
    @Nullable
    private final UUID uuid;

    public PacketSyncAssociation(GlobalPos pos, @Nullable UUID uuid) {
        this.pos = pos;
        this.uuid = uuid;
    }

    public PacketSyncAssociation(FriendlyByteBuf buf) {
        this.pos = buf.readGlobalPos();
        this.uuid = buf.readBoolean() ? buf.readUUID() : null;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeGlobalPos(this.pos);
        buf.writeBoolean(this.uuid != null);
        if (this.uuid != null) {
            buf.writeUUID(this.uuid);
        }
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        if (minecraft.level == null || !minecraft.level.dimension().equals(this.pos.dimension())) {
            return;
        }
        BlockPos targetPos = this.pos.pos();
        BlockEntity be = minecraft.level.getBlockEntity(targetPos);
        if (be == null) {
            return;
        }
        if (this.uuid != null) {
            be.setData(ACRegistry.Attachments.ASSOCIATION, (Object)this.uuid);
        } else {
            be.removeData(ACRegistry.Attachments.ASSOCIATION);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

