/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle.block.tile;

import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import dev.qther.ars_controle.block.tile.IDimensionalHighlighter;
import dev.qther.ars_controle.datagen.ACBlockTagProvider;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.Cached;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScryersLinkageTile
extends ModdedTile
implements IWandable,
IDimensionalHighlighter {
    public ScryersLinkageTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACRegistry.Tiles.SCRYERS_LINKAGE.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        CompoundTag data = this.getPersistentData();
        if (data.contains("block", 4) && data.contains("dimension", 8)) {
            long block = data.getLong("block");
            String dimension = data.getString("dimension");
            this.setData(ACRegistry.Attachments.GLOBAL_POS_TARGET, new GlobalPos(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimension)), BlockPos.of((long)block)));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag data = this.getPersistentData();
        data.remove("block");
        data.remove("dimension");
        super.saveAdditional(tag, registries);
    }

    @Nullable
    public GlobalPos getTarget() {
        return this.getExistingData(ACRegistry.Attachments.GLOBAL_POS_TARGET).orElse(null);
    }

    @Nullable
    public Pair<Level, BlockPos> getTargetInfo() {
        GlobalPos pos = this.getTarget();
        if (pos == null) {
            return null;
        }
        return Pair.of((Object)Cached.getLevelByKey((ResourceKey<Level>)pos.dimension()), (Object)pos.pos());
    }

    public boolean hasTarget() {
        return this.hasData(ACRegistry.Attachments.GLOBAL_POS_TARGET);
    }

    public boolean setBlock(@NotNull Level level, @NotNull BlockPos block) {
        Level thisLevel = this.getLevel();
        if (thisLevel == null) {
            return false;
        }
        BlockState target = level.getBlockState(block);
        if (BuiltInRegistries.BLOCK.wrapAsHolder((Object)target.getBlock()).is(ACBlockTagProvider.SCRYERS_LINKAGE_BLACKLIST)) {
            return false;
        }
        this.setData(ACRegistry.Attachments.GLOBAL_POS_TARGET, new GlobalPos(level.dimension(), block));
        this.notifyChange();
        return true;
    }

    public void removeBlock() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.removeData(ACRegistry.Attachments.GLOBAL_POS_TARGET);
        this.notifyChange();
    }

    private void notifyChange() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.setChanged();
        this.invalidateCapabilities();
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        Block thisBlock = state.getBlock();
        level.updateNeighborsAt(pos, thisBlock);
        level.updateNeighbourForOutputSignal(pos, thisBlock);
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    @Nullable
    private Level getTargetLevel() {
        if (this.level == null) {
            return null;
        }
        GlobalPos target = this.getTarget();
        if (target == null) {
            return null;
        }
        if (this.level.dimension().equals(target.dimension())) {
            return this.level;
        }
        if (this.level.isClientSide) {
            return null;
        }
        return Cached.getLevelByKey((ResourceKey<Level>)target.dimension());
    }

    @Nullable
    private BlockPos getTargetBlock() {
        if (this.level == null) {
            return null;
        }
        GlobalPos target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.pos();
    }

    public IWandable.Result onLastConnection(@Nullable GlobalPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return IWandable.Result.FAIL;
        }
        if (storedPos == null) {
            return IWandable.Result.FAIL;
        }
        ServerLevel level = Cached.getLevelByKey((ResourceKey<Level>)storedPos.dimension());
        if (level == null) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_dimension"));
            return IWandable.Result.FAIL;
        }
        if (!this.setBlock((Level)level, storedPos.pos())) {
            PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            return IWandable.Result.FAIL;
        }
        PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.pos().toShortString(), level.dimension().location().toString()}));
        return IWandable.Result.SUCCESS;
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction face, @Nullable LivingEntity storedEntity, Player player) {
        if (storedPos != null) {
            Level level = player.level();
            if (this.setBlock(level, storedPos)) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.target.set.block", (Object[])new Object[]{storedPos.toShortString(), level.dimension().location().toString()}));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_controle.remote.error.invalid_target"));
            }
        }
    }

    public List<ColorPos> getWandHighlight(List<ColorPos> list) {
        BlockPos target = this.getTargetBlock();
        if (target != null) {
            list.add(ColorPos.centered((BlockPos)target));
        }
        return list;
    }

    @Override
    public List<ColorPos> getWandHighlight(Level level, List<ColorPos> list) {
        Pair<Level, BlockPos> target = this.getTargetInfo();
        if (target != null && target.first() == level) {
            list.add(ColorPos.centered((BlockPos)((BlockPos)target.second())));
        }
        return list;
    }
}

