/*
 * Decompiled with CFR 0.152.
 */
package dev.qther.ars_controle;

import dev.qther.ars_controle.config.ACClientConfig;
import dev.qther.ars_controle.config.ConfigScreenFactory;
import dev.qther.ars_controle.item.RemoteItem;
import dev.qther.ars_controle.packets.ACNetworking;
import dev.qther.ars_controle.packets.serverbound.PacketClearRemote;
import dev.qther.ars_controle.registry.ACRegistry;
import dev.qther.ars_controle.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="ars_controle", dist={Dist.CLIENT})
public class ArsControleClient {
    public ArsControleClient(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ACClientConfig.SPEC);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)new ConfigScreenFactory());
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() == ACRegistry.Items.REMOTE.get()) {
            ACNetworking.sendToServer((CustomPacketPayload)new PacketClearRemote());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRender(RenderLevelStageEvent event) {
        BlockHitResult bhr;
        HitResult hitResult;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (level == null || player == null) {
            return;
        }
        ItemStack remote = player.getMainHandItem();
        if (!remote.is((Item)ACRegistry.Items.REMOTE.get())) {
            return;
        }
        RemoteItem.RemoteData data = RemoteItem.RemoteData.fromItemStack(remote);
        if (data.block().isPresent() && data.block().get().dimension().equals(level.dimension())) {
            RenderUtil.renderBlockOutline(event, data.block().get().pos());
        }
        if (!data.multiple() || data.firstCorner().isEmpty() || !data.firstCorner().get().dimension().equals(level.dimension()) || !((hitResult = mc.hitResult) instanceof BlockHitResult) || (bhr = (BlockHitResult)hitResult).getType() == HitResult.Type.MISS) {
            return;
        }
        RenderUtil.renderAABBOutline(event, AABB.encapsulatingFullBlocks((BlockPos)data.firstCorner().get().pos(), (BlockPos)bhr.getBlockPos()));
    }
}

