/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.item.misc;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.items.parts.PartItem;
import appeng.parts.AEBasePart;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.parts.PartExPatternProvider;
import com.glodblock.github.extendedae.common.tileentities.TileExPatternProvider;
import java.util.List;
import java.util.Map;
import lu.kolja.expandedae.item.abstracts.UpgradeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ExtPatternProviderUpgradeItem
extends UpgradeItem {
    public ExtPatternProviderUpgradeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.expandedae.upgrade.tooltip", (Object[])new Object[]{"an Extended Pattern Provider\n to an Expanded Pattern Provider"}).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity == null) return InteractionResult.PASS;
        BlockPlaceContext ctx = new BlockPlaceContext(context);
        Class<?> tClazz = entity.getClass();
        if (tClazz == TileExPatternProvider.class) {
            BlockState originState = world.getBlockState(pos);
            BlockState state = EAESingletons.EX_PATTERN_PROVIDER.getStateForPlacement(ctx);
            if (state == null) {
                return InteractionResult.PASS;
            }
            for (Map.Entry sp : originState.getValues().entrySet()) {
                Property pt = (Property)sp.getKey();
                Comparable va = (Comparable)sp.getValue();
                try {
                    if (!state.hasProperty(pt)) continue;
                    state = (BlockState)state.setValue(pt, va);
                }
                catch (Exception exception) {}
            }
            BlockEntityType tileType = EAESingletons.EX_PATTERN_PROVIDER.getBlockEntityType();
            BlockEntity te = tileType.create(pos, state);
            this.replaceTile(world, pos, entity, te, state);
            context.getItemInHand().shrink(1);
            return InteractionResult.CONSUME;
        }
        if (!(entity instanceof CableBusBlockEntity)) return InteractionResult.PASS;
        CableBusBlockEntity cable = (CableBusBlockEntity)entity;
        Vec3 hitVec = context.getClickLocation();
        Vec3 hitInBlock = new Vec3(hitVec.x - (double)pos.getX(), hitVec.y - (double)pos.getY(), hitVec.z - (double)pos.getZ());
        IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
        if (!(part instanceof AEBasePart)) return InteractionResult.PASS;
        AEBasePart basePart = (AEBasePart)part;
        if (part.getClass() != PartExPatternProvider.class) return InteractionResult.PASS;
        Direction side = basePart.getSide();
        CompoundTag contents = new CompoundTag();
        PartItem partItem = EAESingletons.EX_PATTERN_PROVIDER_PART;
        part.writeToNBT(contents, (HolderLookup.Provider)world.registryAccess());
        PartExPatternProvider p = (PartExPatternProvider)cable.replacePart((IPartItem)partItem, side, context.getPlayer(), null);
        if (p != null) {
            p.readFromNBT(contents, (HolderLookup.Provider)world.registryAccess());
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

