/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.helper.misc;

import java.util.Objects;
import org.jetbrains.annotations.Contract;

public class Tuple<A, B> {
    public A a;
    public B b;

    public Tuple(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getA() {
        return this.a;
    }

    public void setA(A a) {
        this.a = a;
    }

    public B getB() {
        return this.b;
    }

    public void setB(B b) {
        this.b = b;
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <A, B> Tuple<A, B> of(A a, B b) {
        return new Tuple<A, B>(a, b);
    }

    @SafeVarargs
    public static <A, B> Tuple<A, B>[] arrayOf(Tuple<A, B> ... tuples) {
        return tuples;
    }

    public boolean contains(Object o) {
        return this.equals(o, this.a) || this.equals(o, this.b);
    }

    public boolean isLeft(Object o) {
        return this.equals(o, this.a);
    }

    public boolean isRight(Object o) {
        return this.equals(o, this.b);
    }

    public Tuple<B, A> swap() {
        return Tuple.of(this.b, this.a);
    }

    private boolean equals(Object a, Object b) {
        return Objects.equals(a, b);
    }
}

