/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.registry;

import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class Jetpack {
    private static final ResourceLocation ATTRIBUTE_ID = IronJetpacks.resource("armor.jetpack");
    public static final Jetpack UNDEFINED = new Jetpack("undefined", 0, 4095, 0, 0, "null", 0.0f, 0.0f).setCurios(false);
    public static final StreamCodec<FriendlyByteBuf, Jetpack> STREAM_CODEC = StreamCodec.of(Jetpack::encode, Jetpack::read);
    private final ResourceLocation id;
    public String name;
    public String displayName;
    public int tier;
    public int color;
    public int armorPoints;
    public int enchantablilty;
    public String craftingMaterialString;
    private Ingredient craftingMaterial;
    public JetpackItem item;
    public boolean creative = false;
    public boolean disabled = false;
    public Rarity rarity = Rarity.COMMON;
    public float toughness;
    public float knockbackResistance;
    public boolean curios = true;
    public int capacity;
    public int usage;
    public double speedVert;
    public double accelVert;
    public double speedSide;
    public double speedHoverAscend;
    public double speedHoverDescend;
    public double speedHoverSlow;
    public double sprintSpeed;
    public double sprintSpeedVert;
    public double sprintFuel;

    public Jetpack(String name, int tier, int color, int armorPoints, int enchantability, String craftingMaterialString, float toughness, float knockbackResistance) {
        this.id = IronJetpacks.resource(name);
        this.name = name;
        this.displayName = this.makeDisplayName();
        this.tier = tier;
        this.color = FastColor.ARGB32.color((int)255, (int)color);
        this.armorPoints = armorPoints;
        this.enchantablilty = enchantability;
        this.craftingMaterialString = craftingMaterialString;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public void setStats(int capacity, int usage, double speedVert, double accelVert, double speedSide, double speedHoverAscend, double speedHoverDescend, double speedHoverSlow, double sprintSpeed, double sprintSpeedVert, double sprintFuel) {
        this.capacity = capacity;
        this.usage = usage;
        this.speedVert = speedVert;
        this.accelVert = accelVert;
        this.speedSide = speedSide;
        this.speedHoverAscend = speedHoverAscend;
        this.speedHoverDescend = speedHoverDescend;
        this.speedHoverSlow = speedHoverSlow;
        this.sprintSpeed = sprintSpeed;
        this.sprintSpeedVert = sprintSpeedVert;
        this.sprintFuel = sprintFuel;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Jetpack setCreative() {
        this.creative = true;
        this.tier = -1;
        this.rarity = Rarity.EPIC;
        return this;
    }

    public Jetpack setCreative(boolean set) {
        if (set) {
            this.setCreative();
        }
        return this;
    }

    public Jetpack setDisabled() {
        this.disabled = true;
        return this;
    }

    public Jetpack setDisabled(boolean set) {
        if (set) {
            this.setDisabled();
        }
        return this;
    }

    public Jetpack setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public Jetpack setCurios(boolean curios) {
        this.curios = curios;
        return this;
    }

    public int getTier() {
        return this.tier;
    }

    public Ingredient getCraftingMaterial() {
        if (this.craftingMaterial == null) {
            this.craftingMaterial = Ingredient.EMPTY;
            if (!this.craftingMaterialString.equalsIgnoreCase("null")) {
                String[] parts = this.craftingMaterialString.split(":");
                if (parts.length >= 3 && this.craftingMaterialString.startsWith("tag:")) {
                    TagKey tag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)parts[1], (String)parts[2]));
                    this.craftingMaterial = Ingredient.of((TagKey)tag);
                } else if (parts.length >= 2) {
                    BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1])).ifPresent(value -> {
                        this.craftingMaterial = Ingredient.of((ItemLike[])new ItemLike[]{value});
                    });
                }
            }
        }
        return this.craftingMaterial;
    }

    public Component getDisplayName() {
        String key = String.format("jetpack.%s.name", this.name.replaceAll(" ", "_"));
        if (Language.getInstance().has(key)) {
            return Component.translatable((String)key);
        }
        return Component.literal((String)this.displayName);
    }

    public ItemAttributeModifiers createAttributeModifiers() {
        ItemAttributeModifiers.Builder modifiers = ItemAttributeModifiers.builder();
        modifiers.add(Attributes.ARMOR, new AttributeModifier(ATTRIBUTE_ID, (double)this.armorPoints, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
        modifiers.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(ATTRIBUTE_ID, (double)this.toughness, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
        if (this.knockbackResistance > 0.0f) {
            modifiers.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(ATTRIBUTE_ID, (double)this.knockbackResistance, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST);
        }
        return modifiers.build();
    }

    private String makeDisplayName() {
        String[] parts = this.name.replaceAll(" ", "_").split("_");
        return Arrays.stream(parts).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("disable", Boolean.valueOf(this.disabled));
        json.addProperty("tier", (Number)this.tier);
        json.addProperty("color", Integer.toHexString(this.color & 0xFFFFFF));
        json.addProperty("armorPoints", (Number)this.armorPoints);
        json.addProperty("enchantability", (Number)this.enchantablilty);
        json.addProperty("craftingMaterial", this.craftingMaterialString);
        json.addProperty("creative", Boolean.valueOf(this.creative));
        json.addProperty("rarity", (Number)this.rarity.ordinal());
        json.addProperty("toughness", (Number)Float.valueOf(this.toughness));
        json.addProperty("knockbackResistance", (Number)Float.valueOf(this.knockbackResistance));
        json.addProperty("curios", Boolean.valueOf(this.curios));
        json.addProperty("capacity", (Number)this.capacity);
        json.addProperty("usage", (Number)this.usage);
        json.addProperty("speedVertical", (Number)this.speedVert);
        json.addProperty("accelVertical", (Number)this.accelVert);
        json.addProperty("speedSideways", (Number)this.speedSide);
        json.addProperty("speedHoverAscend", (Number)this.speedHoverAscend);
        json.addProperty("speedHoverDescend", (Number)this.speedHoverDescend);
        json.addProperty("speedHover", (Number)this.speedHoverSlow);
        json.addProperty("sprintSpeedMulti", (Number)this.sprintSpeed);
        json.addProperty("sprintSpeedMultiVertical", (Number)this.sprintSpeedVert);
        json.addProperty("sprintFuelMulti", (Number)this.sprintFuel);
        return json;
    }

    public static Jetpack fromJson(JsonObject json) {
        String name = json.get("name").getAsString();
        boolean disable = json.get("disable").getAsBoolean();
        int tier = json.get("tier").getAsInt();
        int color = Integer.parseInt(json.get("color").getAsString(), 16);
        int armorPoints = json.get("armorPoints").getAsInt();
        int enchantability = json.get("enchantability").getAsInt();
        String craftingMaterialString = json.get("craftingMaterial").getAsString();
        boolean creative = json.get("creative").getAsBoolean();
        Rarity rarity = Rarity.values()[json.get("rarity").getAsInt()];
        float toughness = json.get("toughness").getAsFloat();
        float knockbackResistance = json.get("knockbackResistance").getAsFloat();
        boolean curios = json.get("curios").getAsBoolean();
        Jetpack jetpack = new Jetpack(name, tier, color, armorPoints, enchantability, craftingMaterialString, toughness, knockbackResistance).setRarity(rarity).setCreative(creative).setDisabled(disable).setCurios(curios);
        int capacity = json.get("capacity").getAsInt();
        int usage = json.get("usage").getAsInt();
        double speedVert = json.get("speedVertical").getAsDouble();
        double accelVert = json.get("accelVertical").getAsDouble();
        double speedSide = json.get("speedSideways").getAsDouble();
        double speedHoverAscend = json.get("speedHoverAscend").getAsDouble();
        double speedHoverDescend = json.get("speedHoverDescend").getAsDouble();
        double speedHoverSlow = json.get("speedHover").getAsDouble();
        double sprintSpeed = json.get("sprintSpeedMulti").getAsDouble();
        double sprintSpeedVert = json.get("sprintSpeedMultiVertical").getAsDouble();
        double sprintFuel = json.get("sprintFuelMulti").getAsDouble();
        jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHoverAscend, speedHoverDescend, speedHoverSlow, sprintSpeed, sprintSpeedVert, sprintFuel);
        return jetpack;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.name);
        buffer.writeBoolean(this.disabled);
        buffer.writeVarInt(this.tier);
        buffer.writeVarInt(this.color);
        buffer.writeVarInt(this.armorPoints);
        buffer.writeVarInt(this.enchantablilty);
        buffer.writeUtf(this.craftingMaterialString);
        buffer.writeBoolean(this.creative);
        buffer.writeVarInt(this.rarity.ordinal());
        buffer.writeFloat(this.toughness);
        buffer.writeFloat(this.knockbackResistance);
        buffer.writeBoolean(this.curios);
        buffer.writeVarInt(this.capacity);
        buffer.writeVarInt(this.usage);
        buffer.writeDouble(this.speedVert);
        buffer.writeDouble(this.accelVert);
        buffer.writeDouble(this.speedSide);
        buffer.writeDouble(this.speedHoverAscend);
        buffer.writeDouble(this.speedHoverDescend);
        buffer.writeDouble(this.speedHoverSlow);
        buffer.writeDouble(this.sprintSpeed);
        buffer.writeDouble(this.sprintSpeedVert);
        buffer.writeDouble(this.sprintFuel);
    }

    public static void encode(FriendlyByteBuf buffer, Jetpack jetpack) {
        jetpack.write(buffer);
    }

    public static Jetpack read(FriendlyByteBuf buffer) {
        String name = buffer.readUtf();
        boolean disabled = buffer.readBoolean();
        int tier = buffer.readVarInt();
        int color = buffer.readVarInt();
        int armorPoints = buffer.readVarInt();
        int enchantability = buffer.readVarInt();
        String craftingMaterialString = buffer.readUtf();
        boolean creative = buffer.readBoolean();
        Rarity rarity = Rarity.values()[buffer.readVarInt()];
        float toughness = buffer.readFloat();
        float knockbackResistance = buffer.readFloat();
        boolean curios = buffer.readBoolean();
        Jetpack jetpack = new Jetpack(name, tier, color, armorPoints, enchantability, craftingMaterialString, toughness, knockbackResistance).setRarity(rarity).setCreative(creative).setDisabled(disabled).setCurios(curios);
        int capacity = buffer.readVarInt();
        int usage = buffer.readVarInt();
        double speedVert = buffer.readDouble();
        double accelVert = buffer.readDouble();
        double speedSide = buffer.readDouble();
        double speedHoverAscend = buffer.readDouble();
        double speedHoverDescend = buffer.readDouble();
        double speedHoverSlow = buffer.readDouble();
        double sprintSpeed = buffer.readDouble();
        double sprintSpeedVert = buffer.readDouble();
        double sprintFuel = buffer.readDouble();
        jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHoverAscend, speedHoverDescend, speedHoverSlow, sprintSpeed, sprintSpeedVert, sprintFuel);
        return jetpack;
    }
}

