/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.item.BaseArmorItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.ironjetpacks.client.handler.InputHandler;
import com.blakebr0.ironjetpacks.config.ModConfigs;
import com.blakebr0.ironjetpacks.init.ModArmorMaterials;
import com.blakebr0.ironjetpacks.lib.ModTooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class JetpackItem
extends BaseArmorItem
implements IColored {
    public JetpackItem() {
        super(ModArmorMaterials.JETPACK, ArmorItem.Type.CHESTPLATE, p -> p.stacksTo(1).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)).setNoRepair());
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (stack.isEnchanted()) {
            Rarity rarity = switch (jetpack.rarity) {
                default -> throw new MatchException(null, null);
                case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
                case Rarity.RARE -> Rarity.EPIC;
                case Rarity.EPIC -> jetpack.rarity;
            };
            stack.set(DataComponents.RARITY, (Object)rarity);
        } else {
            stack.set(DataComponents.RARITY, (Object)jetpack.rarity);
        }
    }

    public Component getName(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return Localizable.of((String)"item.ironjetpacks.jetpack").args(new Object[]{jetpack.getDisplayName()}).build();
    }

    public String getDescriptionId(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return Localizable.of((String)"item.ironjetpacks.jetpack").args(new Object[]{jetpack.getDisplayName()}).buildString();
    }

    public int getEnchantmentValue(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return jetpack.enchantablilty;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack chest = JetpackUtils.getEquippedJetpack(player);
            if (chest.isEmpty() || chest != stack) {
                return;
            }
            Item item = chest.getItem();
            if (item instanceof JetpackItem && JetpackUtils.isEngineOn(chest)) {
                boolean hover = JetpackUtils.isHovering(chest);
                if (InputHandler.isHoldingUp(player) || hover && !player.onGround()) {
                    Jetpack jetpack = JetpackUtils.getJetpack(stack);
                    double motionY = player.getDeltaMovement().y();
                    double hoverSpeed = InputHandler.isHoldingDown(player) ? jetpack.speedHoverDescend : jetpack.speedHoverSlow;
                    double currentAccel = jetpack.accelVert * (motionY < 0.3 ? 2.5 : 1.0);
                    double currentSpeedVertical = jetpack.speedVert * (player.isInWater() ? 0.4 : 1.0);
                    double usage = player.isSprinting() || InputHandler.isHoldingSprint(player) ? (double)jetpack.usage * jetpack.sprintFuel : (double)jetpack.usage;
                    boolean creative = jetpack.creative;
                    IEnergyStorage energy = JetpackUtils.getEnergyStorage(chest);
                    if (!player.isCreative() && !creative) {
                        energy.extractEnergy((int)usage, false);
                    }
                    if (hover && player.isFallFlying()) {
                        player.stopFallFlying();
                    }
                    if (energy.getEnergyStored() > 0 || player.isCreative() || creative) {
                        double verticalSprintMulti;
                        double throttle = JetpackUtils.getThrottle(stack);
                        double d = verticalSprintMulti = motionY >= 0.0 && InputHandler.isHoldingSprint(player) ? jetpack.sprintSpeedVert : 1.0;
                        if (InputHandler.isHoldingUp(player)) {
                            if (!hover) {
                                JetpackItem.fly(player, Math.min(motionY + currentAccel, currentSpeedVertical) * throttle * verticalSprintMulti);
                            } else if (InputHandler.isHoldingDown(player)) {
                                JetpackItem.fly(player, Math.min(motionY + currentAccel, -jetpack.speedHoverSlow));
                            } else {
                                JetpackItem.fly(player, Math.min(motionY + currentAccel, jetpack.speedHoverAscend) * throttle * verticalSprintMulti);
                            }
                        } else {
                            JetpackItem.fly(player, Math.min(motionY + currentAccel, -hoverSpeed));
                        }
                        double speedSideways = (player.isCrouching() ? jetpack.speedSide * 0.5 : jetpack.speedSide) * throttle;
                        double speedForward = (player.isSprinting() ? speedSideways * jetpack.sprintSpeed : speedSideways) * throttle;
                        if (!player.isFallFlying()) {
                            if (InputHandler.isHoldingForwards(player)) {
                                player.moveRelative(1.0f, new Vec3(0.0, 0.0, speedForward));
                            }
                            if (InputHandler.isHoldingBackwards(player)) {
                                player.moveRelative(1.0f, new Vec3(0.0, 0.0, -speedSideways * (double)0.8f));
                            }
                            if (InputHandler.isHoldingLeft(player)) {
                                player.moveRelative(1.0f, new Vec3(speedSideways, 0.0, 0.0));
                            }
                            if (InputHandler.isHoldingRight(player)) {
                                player.moveRelative(1.0f, new Vec3(-speedSideways, 0.0, 0.0));
                            }
                        }
                        if (!level.isClientSide()) {
                            player.fallDistance = 0.0f;
                            if (player instanceof ServerPlayer) {
                                ((ServerPlayer)player).connection.aboveGroundTickCount = 0;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return (Boolean)ModConfigs.ENCHANTABLE_JETPACKS.get() != false && jetpack.enchantablilty > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return (Boolean)ModConfigs.ENCHANTABLE_JETPACKS.get() != false && jetpack.enchantablilty > 0;
    }

    public int getBarWidth(ItemStack stack) {
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        int stored = energy.getMaxEnergyStored() - energy.getEnergyStored();
        return Math.round(13.0f - (float)stored * 13.0f / (float)energy.getMaxEnergyStored());
    }

    public int getBarColor(ItemStack stack) {
        IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
        float f = Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isBarVisible(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return !jetpack.creative;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        if (flag.isAdvanced()) {
            tooltip.add((Component)ModTooltips.JETPACK_ID.args(new Object[]{jetpack.getId().toString()}).color(ChatFormatting.DARK_GRAY).build());
            tooltip.add((Component)Component.literal((String)" "));
        }
        if (!jetpack.creative) {
            IEnergyStorage energy = JetpackUtils.getEnergyStorage(stack);
            tooltip.add((Component)Formatting.number((Object)energy.getEnergyStored()).append(" / ").append((Component)Formatting.energy((Object)energy.getMaxEnergyStored())).withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)ModTooltips.INFINITE.build().append(" FE"));
        }
        MutableComponent tier = ModTooltips.TIER.color(jetpack.rarity.color()).args(new Object[]{jetpack.creative ? "C" : Integer.valueOf(jetpack.tier)}).build();
        MutableComponent engine = ModTooltips.ENGINE.color(JetpackUtils.isEngineOn(stack) ? ChatFormatting.GREEN : ChatFormatting.RED).build();
        MutableComponent hover = ModTooltips.HOVER.color(JetpackUtils.isHovering(stack) ? ChatFormatting.GREEN : ChatFormatting.RED).build();
        MutableComponent hud = ModTooltips.HUD.color(JetpackUtils.isHUDEnabled(stack) ? ChatFormatting.GREEN : ChatFormatting.RED).build();
        tooltip.add((Component)ModTooltips.STATE_TOOLTIP_LAYOUT.args(new Object[]{tier, engine, hover, hud}).build());
        MutableComponent throttle = Component.literal((String)((int)(JetpackUtils.getThrottle(stack) * 100.0) + "%"));
        tooltip.add((Component)ModTooltips.THROTTLE.args(new Object[]{throttle}).build());
        if (((Boolean)ModConfigs.ENABLE_ADVANCED_INFO_TOOLTIPS.get()).booleanValue()) {
            tooltip.add((Component)Component.literal((String)" "));
            if (!Screen.hasShiftDown()) {
                tooltip.add((Component)Tooltips.HOLD_SHIFT_FOR_INFO.build());
            } else {
                tooltip.add((Component)ModTooltips.FUEL_USAGE.args(new Object[]{jetpack.usage + " FE/t"}).build());
                tooltip.add((Component)ModTooltips.VERTICAL_SPEED.args(new Object[]{jetpack.speedVert}).build());
                tooltip.add((Component)ModTooltips.VERTICAL_ACCELERATION.args(new Object[]{jetpack.accelVert}).build());
                tooltip.add((Component)ModTooltips.HORIZONTAL_SPEED.args(new Object[]{jetpack.speedSide}).build());
                tooltip.add((Component)ModTooltips.HOVER_SPEED.args(new Object[]{jetpack.speedHoverSlow}).build());
                tooltip.add((Component)ModTooltips.HOVER_ASCEND_SPEED.args(new Object[]{jetpack.speedHoverAscend}).build());
                tooltip.add((Component)ModTooltips.HOVER_DESCEND_SPEED.args(new Object[]{jetpack.speedHoverDescend}).build());
                tooltip.add((Component)ModTooltips.SPRINT_MODIFIER.args(new Object[]{jetpack.sprintSpeed}).build());
                tooltip.add((Component)ModTooltips.SPRINT_VERTICAL_MODIFIER.args(new Object[]{jetpack.sprintSpeedVert}).build());
                tooltip.add((Component)ModTooltips.SPRINT_FUEL_MODIFIER.args(new Object[]{jetpack.sprintFuel}).build());
            }
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return jetpack.createAttributeModifiers();
    }

    public int getColor(int i, ItemStack stack) {
        Jetpack jetpack = JetpackUtils.getJetpack(stack);
        return i == 1 ? jetpack.color : -1;
    }

    private static void fly(Player player, double y) {
        Vec3 motion = player.getDeltaMovement();
        player.setDeltaMovement(motion.x(), y, motion.z());
    }
}

