/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.ingredient;

import com.blakebr0.ironjetpacks.init.ModIngredientTypes;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.Nullable;

public class JetpackTierIngredient
implements ICustomIngredient {
    public static final MapCodec<JetpackTierIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("tier").forGetter(ingredient -> ingredient.tier)).apply((Applicative)builder, JetpackTierIngredient::new));
    private final int tier;
    private ItemStack[] stacks;

    public JetpackTierIngredient(int tier) {
        this.tier = tier;
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return Stream.of(this.stacks);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (!JetpackRegistry.getInstance().getAllTiers().contains(this.tier)) {
            return stack.isEmpty();
        }
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.getItem() != stack.getItem()) continue;
            Jetpack jetpack = JetpackUtils.getJetpack(stack);
            return jetpack != Jetpack.UNDEFINED && jetpack.tier == this.tier;
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.JETPACK_TIER_INGREDIENT.get();
    }

    private void initMatchingStacks() {
        this.stacks = (ItemStack[])JetpackRegistry.getInstance().getJetpacks().stream().filter(j -> j.getTier() == this.tier).map(JetpackUtils::getItemForJetpack).toArray(ItemStack[]::new);
    }

    public static Ingredient of(int tier) {
        return new JetpackTierIngredient(tier).toVanilla();
    }
}

