/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.data.recipe;

import java.util.concurrent.CompletableFuture;
import net.allthemods.alltheores.content.blocks.sets.ATOSetHelper;
import net.allthemods.alltheores.registry.ATORegistry;
import net.allthemods.alltheores.registry.ATOTagRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ATORecipeProvider
extends RecipeProvider {
    public ATORecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, provider);
    }

    private ResourceLocation smeltingRecipeDir(String type, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("smelting/" + name + "/" + type + "_smelting"));
    }

    private ResourceLocation blastingRecipeDir(String type, String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("smelting/" + name + "/" + type + "_blasting"));
    }

    private ResourceLocation shapelessIORecipeDir(String typeIn, String name, String typeOut) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("crafting/" + name + "/" + typeOut + "_from_" + typeIn));
    }

    private ResourceLocation shapelessRecipeDir(String name, String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("crafting/" + name + "/" + type));
    }

    private ResourceLocation hammerRecipeDir(String typeIn, String name, String typeOut) {
        return ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)("crafting/hammer/" + name + "/" + typeOut + "_from_" + typeIn + "_manual_only"));
    }

    private ShapedRecipeBuilder compress(TagKey<Item> tag, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), tag);
    }

    private ShapelessRecipeBuilder uncompress(TagKey<Item> tag, Item output) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).requires(tag);
    }

    private ShapedRecipeBuilder gear(TagKey<Item> tag, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern(" a ").pattern("ana").pattern(" a ").define(Character.valueOf('a'), tag).define(Character.valueOf('n'), Tags.Items.NUGGETS_IRON);
    }

    private ShapedRecipeBuilder rod(TagKey<Item> tag, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("   ").pattern("  a").pattern("ha ").define(Character.valueOf('a'), tag).define(Character.valueOf('h'), ATOTagRegistry.ORE_HAMMERS);
    }

    private ShapedRecipeBuilder plate(TagKey<Item> tag, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("   ").pattern("ha ").pattern("a  ").define(Character.valueOf('a'), tag).define(Character.valueOf('h'), ATOTagRegistry.ORE_HAMMERS);
    }

    private ShapelessRecipeBuilder hammer(TagKey<Item> tag, int amount, Item output) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)amount).requires(ATOTagRegistry.ORE_HAMMERS).requires(tag).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS));
    }

    private ShapedRecipeBuilder hammerBuilder(TagKey<Item> tag, Item output) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern(" as").pattern(" sa").pattern("s  ").define(Character.valueOf('a'), tag).define(Character.valueOf('s'), Tags.Items.RODS_WOODEN);
    }

    private SimpleCookingRecipeBuilder blasting(TagKey<Item> tag, Item output) {
        return SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(tag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.7f, (int)100);
    }

    private SimpleCookingRecipeBuilder smelting(TagKey<Item> tag, Item output) {
        return SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(tag), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.7f, (int)200);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ATOSetHelper.applyToVanillaIngot(set -> {
            this.hammer(set.ORE_BLOCK_ITEM_TAG, 2, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ore", set.name, "dust"));
            this.hammer(set.RAW_TAG, 2, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("raw", set.name, "dust"));
            this.hammer(set.INGOT_TAG, 1, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ingot", set.name, "dust"));
            this.smelting((TagKey<Item>)set.DUST_TAG, set.INGOT).unlockedBy(String.format("has_%s_dust", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.smeltingRecipeDir("dust", set.name));
            this.blasting((TagKey<Item>)set.DUST_TAG, set.INGOT).unlockedBy(String.format("has_%s_dust", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.blastingRecipeDir("dust", set.name));
            this.gear(set.INGOT_TAG, (Item)set.GEAR.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "gear"));
            this.rod(set.INGOT_TAG, (Item)set.ROD.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "rod"));
            this.plate(set.INGOT_TAG, (Item)set.PLATE.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "plate"));
        });
        ATOSetHelper.applyToVanillaGem(set -> {
            this.hammer(set.ORE_BLOCK_ITEM_TAG, 2, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ore", set.name, "dust"));
            this.hammer(set.GEM_TAG, 1, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("gem", set.name, "dust"));
            this.gear(set.GEM_TAG, (Item)set.GEAR.get()).unlockedBy(String.format("has_%s_gem", set.name), ATORecipeProvider.has(set.GEM_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "gear"));
            this.rod(set.GEM_TAG, (Item)set.ROD.get()).unlockedBy(String.format("has_%s_gem", set.name), ATORecipeProvider.has(set.GEM_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "rod"));
            this.plate(set.GEM_TAG, (Item)set.PLATE.get()).unlockedBy(String.format("has_%s_gem", set.name), ATORecipeProvider.has(set.GEM_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "plate"));
        });
        ATOSetHelper.applyToVanillaDebris(set -> {
            this.hammer(set.DEBRIS_ITEM_TAG, 2, set.SCRAP).save(recipeOutput, this.hammerRecipeDir("debris", set.name, "scrap"));
            this.hammer(set.INGOT_TAG, 1, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ingot", set.name, "dust"));
            this.smelting((TagKey<Item>)set.DUST_TAG, set.INGOT).unlockedBy(String.format("has_%s_dust", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.smeltingRecipeDir("dust", set.name));
            this.blasting((TagKey<Item>)set.DUST_TAG, set.INGOT).unlockedBy(String.format("has_%s_dust", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.blastingRecipeDir("dust", set.name));
            this.gear(set.INGOT_TAG, (Item)set.GEAR.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "gear"));
            this.rod(set.INGOT_TAG, (Item)set.ROD.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "rod"));
            this.plate(set.INGOT_TAG, (Item)set.PLATE.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "plate"));
        });
        ATOSetHelper.applyToAlloy(set -> {
            this.uncompress(set.INGOT_TAG, (Item)set.NUGGET.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessIORecipeDir("ingot", set.name, "nugget"));
            this.compress(set.NUGGET_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_%s_nugget", set.name), ATORecipeProvider.has(set.NUGGET_TAG)).save(recipeOutput, this.shapelessIORecipeDir("nugget", set.name, "ingot"));
            this.uncompress((TagKey<Item>)set.BLOCK_ITEM_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_%s_block", set.name), ATORecipeProvider.has((TagKey)set.BLOCK_ITEM_TAG)).save(recipeOutput, this.shapelessIORecipeDir("block", set.name, "ingot"));
            this.compress(set.INGOT_TAG, (Item)set.BLOCK_ITEM.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessIORecipeDir("ingot", set.name, "block"));
            this.hammer(set.INGOT_TAG, 1, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ingot", set.name, "dust"));
            this.gear(set.INGOT_TAG, (Item)set.GEAR.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "gear"));
            this.rod(set.INGOT_TAG, (Item)set.ROD.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "rod"));
            this.plate(set.INGOT_TAG, (Item)set.PLATE.get()).unlockedBy(String.format("has_%s_ingot", set.name), ATORecipeProvider.has(set.INGOT_TAG)).save(recipeOutput, this.shapelessRecipeDir(set.name, "plate"));
            this.blasting((TagKey<Item>)set.DUST_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_%s_dust", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.blastingRecipeDir("dust", set.name));
            this.smelting((TagKey<Item>)set.DUST_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_%s_dust", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.smeltingRecipeDir("dust", set.name));
        });
        ATOSetHelper.applyToIngot(set -> {
            this.uncompress(set.RAW_BLOCK_ITEM_TAG, (Item)set.RAW.get()).unlockedBy(String.format("has_%s_raw_block", set.name), ATORecipeProvider.has(set.RAW_BLOCK_ITEM_TAG)).save(recipeOutput, this.shapelessIORecipeDir("raw", set.name, "raw_block"));
            this.compress(set.RAW_TAG, (Item)set.RAW_BLOCK_ITEM.get()).unlockedBy(String.format("has_raw_%st", set.name), ATORecipeProvider.has(set.RAW_TAG)).save(recipeOutput, this.shapelessIORecipeDir("raw_block", set.name, "raw"));
            this.hammer(set.ORES.ORE_BLOCK_ITEM_TAG, 2, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ore", set.name, "dust"));
            this.hammer(set.RAW_TAG, 2, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("raw", set.name, "dust"));
            this.blasting(set.RAW_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_raw_%s", set.name), ATORecipeProvider.has(set.RAW_TAG)).save(recipeOutput, this.blastingRecipeDir("raw", set.name));
            this.smelting(set.RAW_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_raw_%s", set.name), ATORecipeProvider.has(set.RAW_TAG)).save(recipeOutput, this.smeltingRecipeDir("raw", set.name));
            this.blasting(set.RAW_BLOCK_ITEM_TAG, (Item)set.BLOCK_ITEM.get()).unlockedBy(String.format("has_raw_%s_block", set.name), ATORecipeProvider.has(set.RAW_BLOCK_ITEM_TAG)).save(recipeOutput, this.blastingRecipeDir("raw_block", set.name));
            this.smelting(set.RAW_BLOCK_ITEM_TAG, (Item)set.BLOCK_ITEM.get()).unlockedBy(String.format("has_raw_%s_block", set.name), ATORecipeProvider.has(set.RAW_BLOCK_ITEM_TAG)).save(recipeOutput, this.smeltingRecipeDir("raw_block", set.name));
            this.blasting(set.ORES.ORE_BLOCK_ITEM_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_%s_ore", set.name), ATORecipeProvider.has(set.ORES.ORE_BLOCK_ITEM_TAG)).save(recipeOutput, this.blastingRecipeDir("ore", set.name));
            this.smelting(set.ORES.ORE_BLOCK_ITEM_TAG, (Item)set.INGOT.get()).unlockedBy(String.format("has_%s_ore", set.name), ATORecipeProvider.has(set.ORES.ORE_BLOCK_ITEM_TAG)).save(recipeOutput, this.smeltingRecipeDir("ore", set.name));
        });
        ATOSetHelper.applyToGem(set -> {
            this.uncompress((TagKey<Item>)set.BLOCK_ITEM_TAG, (Item)set.GEM.get()).unlockedBy(String.format("has_%s_block", set.name), ATORecipeProvider.has((TagKey)set.BLOCK_ITEM_TAG)).save(recipeOutput, this.shapelessIORecipeDir("block", set.name, "gem"));
            this.compress(set.GEM_TAG, (Item)set.BLOCK_ITEM.get()).unlockedBy(String.format("has_%s", set.name), ATORecipeProvider.has(set.GEM_TAG)).save(recipeOutput, this.shapelessIORecipeDir("gem", set.name, "block"));
            this.hammer(set.ORES.ORE_BLOCK_ITEM_TAG, 2, (Item)set.GEM.get()).save(recipeOutput, this.hammerRecipeDir("ore", set.name, "gem"));
            this.hammer(set.GEM_TAG, 1, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("gem", set.name, "dust"));
        });
        ATOSetHelper.applyToDust(set -> {
            this.uncompress((TagKey<Item>)set.BLOCK_ITEM_TAG, (Item)set.DUST.get()).unlockedBy(String.format("has_%s_block", set.name), ATORecipeProvider.has((TagKey)set.BLOCK_ITEM_TAG)).save(recipeOutput, this.shapelessIORecipeDir("block", set.name, "dust"));
            this.compress((TagKey<Item>)set.DUST_TAG, (Item)set.BLOCK_ITEM.get()).unlockedBy(String.format("has_%s", set.name), ATORecipeProvider.has((TagKey)set.DUST_TAG)).save(recipeOutput, this.shapelessIORecipeDir("dust", set.name, "block"));
            this.hammer(set.ORES.ORE_BLOCK_ITEM_TAG, 2, (Item)set.DUST.get()).save(recipeOutput, this.hammerRecipeDir("ore", set.name, "dust"));
            this.blasting(set.ORES.ORE_BLOCK_ITEM_TAG, (Item)set.DUST.get()).unlockedBy(String.format("has_%s_ore", set.name), ATORecipeProvider.has(set.ORES.ORE_BLOCK_ITEM_TAG)).save(recipeOutput, this.blastingRecipeDir("ore", set.name));
            this.smelting(set.ORES.ORE_BLOCK_ITEM_TAG, (Item)set.DUST.get()).unlockedBy(String.format("has_%s_ore", set.name), ATORecipeProvider.has(set.ORES.ORE_BLOCK_ITEM_TAG)).save(recipeOutput, this.smeltingRecipeDir("ore", set.name));
        });
        this.compress(ATOTagRegistry.COPPER_NUGGET, Items.COPPER_INGOT).unlockedBy("has_copper_nugget", ATORecipeProvider.has(ATOTagRegistry.COPPER_NUGGET)).save(recipeOutput, this.shapelessIORecipeDir("nugget", "copper", "ingot"));
        this.uncompress((TagKey<Item>)Tags.Items.INGOTS_COPPER, (Item)ATORegistry.COPPER_NUGGET.get()).unlockedBy("has_copper_ingot", ATORecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput, this.shapelessIORecipeDir("ingot", "copper", "nugget"));
        this.hammerBuilder((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER, (Item)ATORegistry.COPPER_ORE_HAMMER.get()).unlockedBy("has_copper_ingot", ATORecipeProvider.has((TagKey)Tags.Items.INGOTS_COPPER)).save(recipeOutput);
        this.hammerBuilder((TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON, (Item)ATORegistry.IRON_ORE_HAMMER.get()).unlockedBy("has_iron", ATORecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(recipeOutput);
        this.hammerBuilder((TagKey<Item>)ATORegistry.BRONZE.BLOCK_ITEM_TAG, (Item)ATORegistry.BRONZE_ORE_HAMMER.get()).unlockedBy("has_bronze_ingot", ATORecipeProvider.has(ATORegistry.INVAR.INGOT_TAG)).save(recipeOutput);
        this.hammerBuilder((TagKey<Item>)ATORegistry.INVAR.BLOCK_ITEM_TAG, (Item)ATORegistry.INVAR_ORE_HAMMER.get()).unlockedBy("has_invar_ingot", ATORecipeProvider.has(ATORegistry.INVAR.INGOT_TAG)).save(recipeOutput);
        this.hammerBuilder((TagKey<Item>)ATORegistry.PLATINUM.BLOCK_ITEM_TAG, (Item)ATORegistry.PLATINUM_ORE_HAMMER.get()).unlockedBy("has_platinum_ingot", ATORecipeProvider.has(ATORegistry.INVAR.INGOT_TAG)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.INVAR.DUST.get()), (int)3).requires((ItemLike)ATORegistry.IRON.DUST.get(), 2).requires(ATORegistry.NICKEL.DUST_TAG).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "invar", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.STEEL.DUST.get()), (int)1).requires((ItemLike)ATORegistry.IRON.DUST.get(), 1).requires((ItemLike)Items.COAL, 4).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "steel", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.ELECTRUM.DUST.get()), (int)2).requires((ItemLike)ATORegistry.GOLD.DUST.get()).requires(ATORegistry.SILVER.DUST_TAG).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "electrum", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.BRONZE.DUST.get()), (int)4).requires((ItemLike)ATORegistry.COPPER.DUST.get(), 3).requires(ATORegistry.TIN.DUST_TAG).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "bronze", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.BRASS.DUST.get()), (int)4).requires((ItemLike)ATORegistry.COPPER.DUST.get(), 3).requires(ATORegistry.ZINC.DUST_TAG).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "brass", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.LUMIUM.DUST.get()), (int)4).requires((ItemLike)Items.GLOWSTONE_DUST, 4).requires(ATORegistry.SILVER.DUST_TAG).requires((ItemLike)ATORegistry.TIN.DUST.get(), 3).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "lumium", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.CONSTANTAN.DUST.get()), (int)2).requires((ItemLike)ATORegistry.COPPER.DUST.get()).requires(ATORegistry.NICKEL.DUST_TAG).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "constantan", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.SIGNALUM.DUST.get()), (int)4).requires((ItemLike)ATORegistry.COPPER.DUST.get(), 3).requires(ATORegistry.SILVER.DUST_TAG).requires((ItemLike)Items.REDSTONE, 4).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "signalum", "alloy_blending"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ATORegistry.ENDERIUM.DUST.get()), (int)4).requires((ItemLike)ATORegistry.LEAD.DUST.get(), 3).requires(ATORegistry.PLATINUM.DUST_TAG).requires((ItemLike)Items.ENDER_PEARL, 2).requires(ATOTagRegistry.ORE_HAMMERS).unlockedBy("has_hammer", ATORecipeProvider.has(ATOTagRegistry.ORE_HAMMERS)).save(recipeOutput, this.shapelessIORecipeDir("dust", "enderium", "alloy_blending"));
    }
}

