/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl.data.recipe.soil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.common.api.util.DataHelper;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.api.data.display.types.DisplayType;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.data.display.types.BasicOptions;
import net.darkhax.botanypots.common.impl.data.display.types.SimpleDisplayState;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BasicSoil;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BlockDerivedSoil
extends BasicSoil {
    public static final MapCodec<BlockDerivedSoil> CODEC = BlockProperties.CODEC.xmap(BlockDerivedSoil::new, BlockDerivedSoil::getBlockProperties);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockDerivedSoil> STREAM = BlockProperties.STREAM.map(BlockDerivedSoil::new, BlockDerivedSoil::getBlockProperties);
    public static final RecipeSerializer<BlockDerivedSoil> SERIALIZER = DataHelper.recipeSerializer(CODEC, STREAM);
    private final BlockProperties properties;

    public BlockDerivedSoil(BlockProperties properties) {
        super(properties.toBasic());
        this.properties = properties;
    }

    public BlockProperties getBlockProperties() {
        return this.properties;
    }

    public record BlockProperties(Block block, Optional<Ingredient> input, Optional<Display> display, float growthModifier, int lightLevel, Optional<BasicOptions> renderOptions, float dropModifier) {
        public static final MapCodec<BlockProperties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(BlockProperties::block), (App)Ingredient.CODEC.optionalFieldOf("input").forGetter(BlockProperties::input), (App)DisplayType.DISPLAY_STATE_CODEC.optionalFieldOf("display").forGetter(BlockProperties::display), (App)Codec.FLOAT.optionalFieldOf("growth_modifier", (Object)Float.valueOf(0.0f)).forGetter(BlockProperties::growthModifier), (App)Codec.INT.optionalFieldOf("light_level", (Object)0).forGetter(BlockProperties::lightLevel), (App)BasicOptions.CODEC.optionalFieldOf("render_options").forGetter(BlockProperties::renderOptions), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("yield_modifier", (Object)Float.valueOf(0.0f)).forGetter(BlockProperties::dropModifier)).apply((Applicative)instance, BlockProperties::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockProperties> STREAM = StreamCodec.of((buf, props) -> {
            Helpers.BLOCK_STREAM.encode(buf, (Object)props.block);
            BasicSoil.Properties.STREAM.encode(buf, (Object)props.toBasic());
        }, buf -> {
            Block block = (Block)Helpers.BLOCK_STREAM.decode(buf);
            BasicSoil.Properties properties = (BasicSoil.Properties)BasicSoil.Properties.STREAM.decode(buf);
            return BlockProperties.fromBasic(block, properties);
        });

        public BasicSoil.Properties toBasic() {
            Ingredient input = this.input.orElseGet(() -> BlockProperties.getSoil(this.block));
            BasicOptions options = this.renderOptions.orElseGet(() -> BasicOptions.ofDefault(Set.of(Direction.UP)));
            Display display = this.display.orElseGet(() -> new SimpleDisplayState(this.block.defaultBlockState(), options));
            return new BasicSoil.Properties(input, display, this.growthModifier, this.lightLevel, this.dropModifier);
        }

        public static BlockProperties fromBasic(Block block, BasicSoil.Properties properties) {
            return new BlockProperties(block, Optional.of(properties.input()), Optional.of(properties.display()), properties.growthModifier(), properties.lightLevel(), Optional.empty(), properties.yieldModifier());
        }

        private static Ingredient getSoil(Block block) {
            Item blockItem = block.asItem();
            if (blockItem != Items.AIR) {
                return Ingredient.of((ItemLike[])new ItemLike[]{blockItem});
            }
            throw new IllegalStateException("Can not derive soil from block " + String.valueOf(block) + " id=" + String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)block)));
        }
    }
}

