/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.bookshelf.common.api.registry.ContentProvider;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.registry.adapters.GenericRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockEntityRendererAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRegistryAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.BlockRenderTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.CreativeModeTabAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuScreenAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.MenuTypeAdapter;
import net.darkhax.bookshelf.common.impl.registry.adapter.RecipeTypeAdapter;
import net.darkhax.botanypots.common.api.BotanyPotsPlugin;
import net.darkhax.botanypots.common.api.data.components.CropOverride;
import net.darkhax.botanypots.common.api.data.components.SoilOverride;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.darkhax.botanypots.common.impl.Helpers;
import net.darkhax.botanypots.common.impl.block.BotanyPotBlock;
import net.darkhax.botanypots.common.impl.block.BotanyPotRenderer;
import net.darkhax.botanypots.common.impl.block.PotType;
import net.darkhax.botanypots.common.impl.block.entity.BotanyPotBlockEntity;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotMenu;
import net.darkhax.botanypots.common.impl.block.menu.BotanyPotScreen;
import net.darkhax.botanypots.common.impl.command.BotanyPotsCommands;
import net.darkhax.botanypots.common.impl.data.BotanyPotFileGenerator;
import net.darkhax.botanypots.common.impl.data.conditions.ConfigLoadCondition;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BasicCrop;
import net.darkhax.botanypots.common.impl.data.recipe.crop.BlockDerivedCrop;
import net.darkhax.botanypots.common.impl.data.recipe.fertilizer.BasicFertilizer;
import net.darkhax.botanypots.common.impl.data.recipe.interaction.BasicPotInteraction;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BasicSoil;
import net.darkhax.botanypots.common.impl.data.recipe.soil.BlockDerivedSoil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.MapColor;

public class BotanyPotsContent
implements ContentProvider {
    public static final Supplier<ItemStack> TAB_ICON = CachedSupplier.cache(() -> ((Item)BuiltInRegistries.ITEM.get(BotanyPotsMod.id("terracotta_botany_pot"))).getDefaultInstance());
    private static final String[] BRICK_TYPES = new String[]{"brick", "stone", "mossy_stone", "deepslate", "tuff", "mud", "prismarine", "nether", "red_nether", "polished_blackstone", "end_stone", "quartz"};
    private final Map<ResourceLocation, Block> allPotBlocks = new LinkedHashMap<ResourceLocation, Block>();

    private void generatePotFiles() {
        BotanyPotFileGenerator gen = new BotanyPotFileGenerator(new File("outdir"), "botanypots");
        this.make(gen, "terracotta");
        for (DyeColor dyeColor : DyeColor.values()) {
            this.make(gen, dyeColor.getName() + "_terracotta");
            this.make(gen, dyeColor.getName() + "_glazed_terracotta");
            this.make(gen, dyeColor.getName() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.make(gen, (String)(string.equalsIgnoreCase("brick") ? "bricks" : string + "_bricks"));
        }
    }

    private void make(BotanyPotFileGenerator gen, String block) {
        ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)block);
        gen.potRecipes(blockId);
        gen.models(blockId);
        gen.lootTables(blockId);
    }

    public void defineBlocks(BlockRegistryAdapter registry) {
        this.createPots(registry, "terracotta");
        for (DyeColor dyeColor : DyeColor.values()) {
            this.createPots(registry, dyeColor.getName() + "_terracotta");
            this.createPots(registry, dyeColor.getName() + "_glazed_terracotta");
            this.createPots(registry, dyeColor.getName() + "_concrete");
        }
        for (String string : BRICK_TYPES) {
            this.createPots(registry, (String)("brick".equals(string) ? "bricks" : string + "_bricks"));
        }
    }

    private void createPots(BlockRegistryAdapter registry, String name) {
        ResourceLocation blockId = ResourceLocation.withDefaultNamespace((String)name);
        MapColor color = BuiltInRegistries.BLOCK.containsKey(blockId) ? ((Block)BuiltInRegistries.BLOCK.get(blockId)).defaultMapColor() : MapColor.COLOR_ORANGE;
        this.definePot(registry, name + "_botany_pot", (Block)new BotanyPotBlock(color, PotType.BASIC));
        this.definePot(registry, name + "_hopper_botany_pot", (Block)new BotanyPotBlock(color, PotType.HOPPER));
        this.definePot(registry, name + "_waxed_botany_pot", (Block)new BotanyPotBlock(color, PotType.WAXED));
    }

    private void definePot(BlockRegistryAdapter registry, String id, Block block) {
        ResourceLocation blockId = ResourceLocation.fromNamespaceAndPath((String)this.namespace(), (String)id);
        registry.addPlaceable(id, () -> block);
        this.allPotBlocks.put(blockId, block);
    }

    public void defineBlockEntities(GameRegistryAdapter<BlockEntityType<?>> registry) {
        registry.add("botany_pot", (Object)Services.GAMEPLAY.blockEntityBuilder(BotanyPotBlockEntity::new, (Block[])this.allPotBlocks.values().toArray(Block[]::new)).build(null));
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerDisplayTypes);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerDropProviders);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::registerGrowthAmountTypes);
    }

    public void defineMenuType(MenuTypeAdapter registry) {
        registry.add("basic_pot_menu", BotanyPotMenu::basicMenuClient);
        registry.add("hopper_pot_menu", BotanyPotMenu::hopperMenuClient);
    }

    public void defineRecipeTypes(RecipeTypeAdapter registry) {
        registry.add("soil");
        registry.add("crop");
        registry.add("pot_interaction");
        registry.add("fertilizer");
    }

    public void defineRecipeSerializers(GameRegistryAdapter<RecipeSerializer<?>> registry) {
        registry.add("soil", BasicSoil.SERIALIZER);
        registry.add("block_derived_soil", BlockDerivedSoil.SERIALIZER);
        registry.add("crop", BasicCrop.SERIALIZER);
        registry.add("block_derived_crop", BlockDerivedCrop.SERIALIZER);
        registry.add("pot_interaction", BasicPotInteraction.SERIALIZER);
        registry.add("fertilizer", BasicFertilizer.SERIALIZER);
    }

    public void defineLoadConditions(GenericRegistryAdapter<MapCodec<? extends ILoadCondition>> registry) {
        registry.add(ConfigLoadCondition.TYPE_ID, ConfigLoadCondition.CODEC);
    }

    public void defineCreativeTabs(CreativeModeTabAdapter registry) {
        registry.add("tab", TAB_ICON, (params, builder) -> {
            for (Block block : this.allPotBlocks.values()) {
                builder.accept((ItemLike)block.asItem());
            }
            float[] buffs = new float[]{0.25f, 0.5f, 0.75f, 1.0f, 5.0f, 10.0f, 15.0f, 50.0f, 100.0f, 1000.0f};
            ResourceLocation yieldId = BotanyPotsMod.id("test_yield");
            ResourceLocation growthId = BotanyPotsMod.id("test_growth");
            for (float buff : buffs) {
                ItemStack yield = new ItemStack((ItemLike)Items.DIAMOND_HOE);
                Helpers.addModifier(yield, Helpers.YIELD_MOD_ATTRIBUTE.get(), new AttributeModifier(yieldId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                yield.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                builder.accept(yield);
            }
            for (float buff : buffs) {
                ItemStack growth = new ItemStack((ItemLike)Items.GOLDEN_HOE);
                Helpers.addModifier(growth, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new AttributeModifier(growthId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                growth.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                builder.accept(growth);
            }
            for (float buff : buffs) {
                ItemStack both = new ItemStack((ItemLike)Items.NETHERITE_HOE);
                Helpers.addModifier(both, Helpers.YIELD_MOD_ATTRIBUTE.get(), new AttributeModifier(yieldId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                Helpers.addModifier(both, Helpers.GROWTH_MOD_ATTRIBUTE.get(), new AttributeModifier(growthId, (double)buff, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
                both.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                builder.accept(both);
            }
        });
    }

    public void defineCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context, Commands.CommandSelection selection) {
        BotanyPotsCommands.build(dispatcher, context, selection);
    }

    public void defineBlockRenderers(BlockEntityRendererAdapter registry) {
        registry.bind((BlockEntityType)BotanyPotBlockEntity.TYPE.get(), BotanyPotRenderer::new);
        ((List)BotanyPotsPlugin.PLUGINS.get()).forEach(BotanyPotsPlugin::bindDisplayRenderers);
    }

    public void defineItemComponents(GameRegistryAdapter<DataComponentType<?>> registry) {
        registry.add(CropOverride.TYPE_ID.getPath(), (Object)new DataComponentType.Builder().persistent(CropOverride.CODEC).networkSynchronized(CropOverride.STREAM).build());
        registry.add(SoilOverride.TYPE_ID.getPath(), (Object)new DataComponentType.Builder().persistent(SoilOverride.CODEC).networkSynchronized(SoilOverride.STREAM).build());
    }

    public void defineMenuScreens(MenuScreenAdapter registry) {
        registry.bind((MenuType)BotanyPotMenu.BASIC_MENU.get(), BotanyPotScreen::new);
        registry.bind((MenuType)BotanyPotMenu.HOPPER_MENU.get(), BotanyPotScreen::new);
    }

    public void defineBlockRenderTypes(BlockRenderTypeAdapter registry) {
        for (Block block : this.allPotBlocks.values()) {
            registry.add(block, RenderType.cutout());
        }
    }

    public void defineAttributes(GameRegistryAdapter<Attribute> registry) {
        registry.add("growth", (Object)new RangedAttribute("attribute.botanypots.growth", 0.0, -3.4028234663852886E38, 3.4028234663852886E38));
        registry.add("yield", (Object)new RangedAttribute("attribute.botanypots.yield", 0.0, -3.4028234663852886E38, 3.4028234663852886E38));
    }

    public String namespace() {
        return "botanypots";
    }

    public static Component modMessage(Component component) {
        return Component.translatable((String)"commands.botanypots.mod_message", (Object[])new Object[]{component});
    }
}

