/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data.display.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.botanypots.common.api.data.display.types.Display;
import net.darkhax.botanypots.common.impl.BotanyPotsMod;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DisplayType<T extends Display>(ResourceLocation typeId, MapCodec<T> codec, StreamCodec<FriendlyByteBuf, T> stream) {
    private static final Map<ResourceLocation, DisplayType<? extends Display>> REGISTRY = new HashMap<ResourceLocation, DisplayType<? extends Display>>();
    public static final Codec<DisplayType<?>> TYPE_CODEC = ResourceLocation.CODEC.xmap(REGISTRY::get, DisplayType::typeId);
    public static final StreamCodec<ByteBuf, ? extends DisplayType<? extends Display>> TYPE_STREAM = ResourceLocation.STREAM_CODEC.map(REGISTRY::get, DisplayType::typeId);
    public static final Codec<Display> DISPLAY_STATE_CODEC = TYPE_CODEC.dispatch(Display::getType, DisplayType::codec);
    public static final StreamCodec<FriendlyByteBuf, Display> DISPLAY_STATE_STREAM = new StreamCodec<FriendlyByteBuf, Display>(){

        @NotNull
        public Display decode(@NotNull FriendlyByteBuf buf) {
            ResourceLocation id = buf.readResourceLocation();
            if (!REGISTRY.containsKey(id)) {
                BotanyPotsMod.LOG.error("Display type {} does not exist!", (Object)id);
                throw new IllegalStateException("Display type " + String.valueOf(id) + " does not exist!");
            }
            return (Display)DisplayType.REGISTRY.get((Object)id).stream.decode((Object)buf);
        }

        public void encode(@NotNull FriendlyByteBuf buf, @NotNull Display state) {
            buf.writeResourceLocation(state.getType().typeId());
            state.getType().stream().encode((Object)buf, (Object)state);
        }
    };
    public static final Codec<List<Display>> LIST_CODEC = MapCodecs.flexibleList(DISPLAY_STATE_CODEC);

    @Nullable
    public static <T extends Display> DisplayType<T> get(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    public static <T extends Display> DisplayType<T> register(ResourceLocation id, MapCodec<T> codec, StreamCodec<FriendlyByteBuf, T> buffer) {
        DisplayType<T> type = new DisplayType<T>(id, codec, buffer);
        if (REGISTRY.containsKey(id)) {
            BotanyPotsMod.LOG.warn("Display type ID {} has already been assigned to {}. You can not set it to {}.", new Object[]{id, REGISTRY.get(id), type});
            throw new IllegalStateException("Display type " + id.toString() + " has already been registered!");
        }
        REGISTRY.put(id, type);
        return type;
    }
}

