/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.common.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public record SoundEffect(Holder<SoundEvent> sound, SoundSource source, float volume, float pitch) {
    public static final MapCodec<SoundEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SoundEvent.CODEC.fieldOf("id").forGetter(SoundEffect::sound), (App)MapCodecs.enumerable(SoundSource.class).optionalFieldOf("category", (Object)SoundSource.MASTER).forGetter(SoundEffect::source), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(SoundEffect::volume), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(SoundEffect::pitch)).apply((Applicative)instance, SoundEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoundEffect> STREAM = StreamCodec.of((buf, val) -> {
        SoundEvent.STREAM_CODEC.encode(buf, val.sound);
        buf.writeEnum((Enum)val.source);
        buf.writeFloat(val.volume);
        buf.writeFloat(val.pitch);
    }, buf -> {
        Holder sound = (Holder)SoundEvent.STREAM_CODEC.decode(buf);
        SoundSource source = (SoundSource)buf.readEnum(SoundSource.class);
        float volume = buf.readFloat();
        float pitch = buf.readFloat();
        return new SoundEffect((Holder<SoundEvent>)sound, source, volume, pitch);
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<SoundEffect>> OPTIONAL_STREAM = StreamCodec.of((buf, val) -> {
        buf.writeBoolean(val.isPresent());
        val.ifPresent(soundEffect -> STREAM.encode(buf, soundEffect));
    }, buf -> {
        boolean isPresent = buf.readBoolean();
        return isPresent ? Optional.of((SoundEffect)STREAM.decode(buf)) : Optional.empty();
    });

    public void playSound(ServerLevel level, Player player, BlockPos pos) {
        this.playSound(level, player, (float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
    }

    public void playSound(ServerLevel level, Player player, float x, float y, float z) {
        level.playSound(player, (double)x, (double)y, (double)z, this.sound, this.source, this.volume, this.pitch);
    }
}

