/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.closegui.CloseGuiCommandPacket;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class CloseGuiScreenCommand {
    public static void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"closeguiscreen").executes(stack -> CloseGuiScreenCommand.closeGui((CommandSourceStack)stack.getSource(), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"target_players", (ArgumentType)EntityArgument.players()).requires(stack -> stack.hasPermission(2))).executes(stack -> CloseGuiScreenCommand.closeGui((CommandSourceStack)stack.getSource(), EntityArgument.getPlayers((CommandContext)stack, (String)"target_players")))));
    }

    private static int closeGui(CommandSourceStack stack, @Nullable Collection<ServerPlayer> targets) {
        try {
            if (targets == null) {
                ServerPlayer sender = stack.getPlayerOrException();
                CloseGuiCommandPacket packet = new CloseGuiCommandPacket();
                PacketHandler.sendToClient(sender, packet);
            } else {
                for (ServerPlayer target : targets) {
                    CloseGuiCommandPacket packet = new CloseGuiCommandPacket();
                    PacketHandler.sendToClient(target, packet);
                }
            }
        }
        catch (Exception ex) {
            stack.sendFailure((Component)Component.literal((String)"Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }
}

