/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.api.StorageType;
import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.container.ContainerEnderItemStorage;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.network.EnderStorageSPH;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.inventory.container.CCLMenuType;
import codechicken.lib.util.ArrayUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EnderItemStorage
extends AbstractEnderStorage
implements Container {
    public static final StorageType<EnderItemStorage> TYPE = new StorageType("item");
    public static final int[] sizes = new int[]{9, 27, 54};
    private int size = EnderStorageConfig.storageSize;
    private ItemStack[] items = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[this.getContainerSize()], (Object)ItemStack.EMPTY);
    private int open;

    public EnderItemStorage(EnderStorageManager manager, Frequency freq) {
        super(manager, freq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.size = tag.getByte("size");
        this.empty();
        InventoryUtils.readItemStacksFromTag((HolderLookup.Provider)registries, (ItemStack[])this.items, (ListTag)tag.getList("Items", 10));
        if (this.size != EnderStorageConfig.storageSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderStorageConfig.storageSize > this.size) {
            ItemStack[] newItems = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[sizes[EnderStorageConfig.storageSize]], (Object)ItemStack.EMPTY);
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderStorageConfig.storageSize;
            this.setChanged();
        } else {
            int numStacks = 0;
            for (ItemStack item : this.items) {
                if (item.isEmpty()) continue;
                ++numStacks;
            }
            if (numStacks <= sizes[EnderStorageConfig.storageSize]) {
                ItemStack[] newItems = (ItemStack[])ArrayUtils.fill((Object[])new ItemStack[sizes[EnderStorageConfig.storageSize]], (Object)ItemStack.EMPTY);
                int copyTo = 0;
                for (ItemStack item : this.items) {
                    if (item.isEmpty()) continue;
                    newItems[copyTo] = item;
                    ++copyTo;
                }
                this.items = newItems;
                this.size = EnderStorageConfig.storageSize;
                this.setChanged();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public CompoundTag saveToTag(HolderLookup.Provider registries) {
        if (this.size != EnderStorageConfig.storageSize && this.open == 0) {
            this.alignSize();
        }
        CompoundTag compound = new CompoundTag();
        compound.put("Items", (Tag)InventoryUtils.writeItemStacksToTag((HolderLookup.Provider)registries, (ItemStack[])this.items));
        compound.putByte("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getItem(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack removeItemNoUpdate(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.removeStackFromSlot((Container)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItem(int slot, ItemStack stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.setChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int getContainerSize() {
        return sizes[this.size];
    }

    public boolean isEmpty() {
        return ArrayUtils.count((Object[])this.items, stack -> !stack.isEmpty()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack removeItem(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((Container)this, (int)slot, (int)size);
        }
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void setChanged() {
        this.setDirty();
    }

    public boolean stillValid(Player var1) {
        return true;
    }

    public void empty() {
        this.items = new ItemStack[this.getContainerSize()];
        ArrayUtils.fill((Object[])this.items, (Object)ItemStack.EMPTY);
    }

    public void openContainer(ServerPlayer player, Component title) {
        CCLMenuType.openMenu((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ContainerEnderItemStorage(id, inv, this), title), packet -> {
            this.freq.writeToPacket((MCDataOutput)packet);
            packet.writeByte(this.size);
        });
    }

    public void handleContainerPacket(MCDataInput packet) {
        this.size = packet.readByte();
        this.empty();
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return true;
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public void clearContent() {
    }
}

