/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.test.framework;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.test.framework.MdGameTestHelper;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class PipeBuilder {
    private final MdGameTestHelper helper;
    private final PipeBlockEntity pipe;

    public PipeBuilder(MdGameTestHelper helper, PipeBlockEntity pipe) {
        this.helper = helper;
        this.pipe = pipe;
    }

    public PipeBuilder attachment(Direction direction, AttachmentItem attachment) {
        ItemStack stack = attachment.getDefaultInstance();
        for (NodeHost host : this.pipe.getHosts()) {
            if (!host.acceptsAttachment(attachment, stack)) continue;
            host.setAttachment(direction, attachment, new CompoundTag(), (HolderLookup.Provider)this.pipe.getLevel().registryAccess());
            this.helper.getLevel().blockUpdated(this.pipe.getBlockPos(), this.pipe.getBlockState().getBlock());
            this.pipe.refreshHosts();
            this.pipe.scheduleHostUpdates();
            this.pipe.setChanged();
            this.pipe.sync();
            return this;
        }
        this.helper.fail("Failed to add attachment " + String.valueOf((Object)attachment) + " to pipe", this.pipe.getBlockPos());
        throw new UnsupportedOperationException();
    }

    public PipeBuilder configureFluidIo(Direction direction, Consumer<FluidAttachedIo> config) {
        AttachedAttachment attachedAttachment = this.pipe.getAttachment(direction);
        if (attachedAttachment instanceof FluidAttachedIo) {
            FluidAttachedIo fluidIo = (FluidAttachedIo)attachedAttachment;
            config.accept(fluidIo);
            return this;
        }
        this.helper.fail("Failed to find item io from pipe", this.pipe.getBlockPos());
        throw new UnsupportedOperationException();
    }

    public PipeBuilder configureItemIo(Direction direction, Consumer<ItemAttachedIo> config) {
        AttachedAttachment attachedAttachment = this.pipe.getAttachment(direction);
        if (attachedAttachment instanceof ItemAttachedIo) {
            ItemAttachedIo itemIo = (ItemAttachedIo)attachedAttachment;
            config.accept(itemIo);
            return this;
        }
        this.helper.fail("Failed to find item io from pipe", this.pipe.getBlockPos());
        throw new UnsupportedOperationException();
    }
}

