/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.pipe;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBoundingBoxes {
    public static final float CORE_SIZE = 0.375f;
    public static final float CORE_START = 0.3125f;
    public static final float CORE_END = 0.6875f;
    public static final VoxelShape CORE_SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    public static final VoxelShape[] PIPE_CONNECTIONS = PipeBoundingBoxes.buildSideShapes(0.375, 0.3125);
    public static final VoxelShape[] CONNECTOR_SHAPES = PipeBoundingBoxes.buildSideShapes(0.5, 0.25);
    public static final VoxelShape[] INVENTORY_CONNECTIONS = PipeBoundingBoxes.combinePiecewise(PIPE_CONNECTIONS, CONNECTOR_SHAPES);
    private static final ConcurrentHashMap<Integer, VoxelShape> pipeShapeCache = new ConcurrentHashMap();

    public static VoxelShape[] buildSideShapes(double connectorSide, double connectorDepth) {
        double connectorSideStart = (1.0 - connectorSide) / 2.0;
        double connectorSideEnd = connectorSideStart + connectorSide;
        return new VoxelShape[]{Shapes.box((double)connectorSideStart, (double)0.0, (double)connectorSideStart, (double)connectorSideEnd, (double)connectorDepth, (double)connectorSideEnd), Shapes.box((double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideEnd, (double)1.0, (double)connectorSideEnd), Shapes.box((double)connectorSideStart, (double)connectorSideStart, (double)0.0, (double)connectorSideEnd, (double)connectorSideEnd, (double)connectorDepth), Shapes.box((double)connectorSideStart, (double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideEnd, (double)connectorSideEnd, (double)1.0), Shapes.box((double)0.0, (double)connectorSideStart, (double)connectorSideStart, (double)connectorDepth, (double)connectorSideEnd, (double)connectorSideEnd), Shapes.box((double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideStart, (double)1.0, (double)connectorSideEnd, (double)connectorSideEnd)};
    }

    public static VoxelShape[] buildCombinedShapes(VoxelShape[] sideShapes) {
        VoxelShape[] combinedShapes = new VoxelShape[64];
        for (int mask = 0; mask < 64; ++mask) {
            VoxelShape currentShape = CORE_SHAPE;
            for (int i = 0; i < 6; ++i) {
                if ((mask & 1 << i) <= 0) continue;
                currentShape = Shapes.or((VoxelShape)currentShape, (VoxelShape)sideShapes[i]);
            }
            combinedShapes[mask] = currentShape.optimize();
        }
        return combinedShapes;
    }

    public static VoxelShape[] combinePiecewise(VoxelShape[] part1, VoxelShape[] part2) {
        VoxelShape[] combinedShapes = new VoxelShape[6];
        for (int i = 0; i < 6; ++i) {
            combinedShapes[i] = Shapes.or((VoxelShape)part1[i], (VoxelShape)part2[i]).optimize();
        }
        return combinedShapes;
    }

    public static VoxelShape getPipeShape(int pipeConnections, int inventoryConnections, int attachments) {
        int cacheKey = pipeConnections | (inventoryConnections |= attachments) << 6;
        VoxelShape cachedShape = pipeShapeCache.get(cacheKey);
        if (cachedShape != null) {
            return cachedShape;
        }
        int allConnections = pipeConnections | inventoryConnections;
        VoxelShape shape = CORE_SHAPE;
        for (int i = 0; i < 6; ++i) {
            if ((allConnections & 1 << i) > 0) {
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)PIPE_CONNECTIONS[i]);
            }
            if ((inventoryConnections & 1 << i) <= 0) continue;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CONNECTOR_SHAPES[i]);
        }
        pipeShapeCache.put(cacheKey, shape);
        return shape;
    }
}

