/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.gui.menu;

import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.gui.menu.AttachedIoMenu;
import dev.technici4n.moderndynamics.gui.menu.FluidConfigSlot;
import dev.technici4n.moderndynamics.init.MdMenus;
import dev.technici4n.moderndynamics.packets.MdPackets;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import dev.technici4n.moderndynamics.util.FluidVariant;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidAttachedIoMenu
extends AttachedIoMenu<FluidAttachedIo> {
    public FluidAttachedIoMenu(int syncId, Inventory playerInventory, PipeBlockEntity pipe, Direction side, FluidAttachedIo attachment) {
        super(MdMenus.FLUID_IO, syncId, playerInventory, pipe, side, attachment);
        int row = 0;
        int col = 0;
        for (int i = 0; i < 15; ++i) {
            this.addSlot(new FluidConfigSlot(44 + col * 18, 20 + row * 18, attachment, i));
            if (++col < 5) continue;
            col = 0;
            ++row;
        }
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        FluidConfigSlot configSlot;
        Slot slot;
        if (slotIndex >= 0 && (slot = this.getSlot(slotIndex)) instanceof FluidConfigSlot && (configSlot = (FluidConfigSlot)slot).isActive()) {
            FluidStack contained = FluidUtil.getFluidContained((ItemStack)this.getCarried()).orElse(FluidStack.EMPTY);
            ((FluidAttachedIo)this.attachment).setFilter(configSlot.getConfigIdx(), FluidVariant.of(contained));
        } else {
            super.clicked(slotIndex, button, actionType, player);
        }
    }

    private boolean matchesAnyFilter(FluidStack stack) {
        for (Slot slot : this.slots) {
            FluidConfigSlot fluidConfig;
            if (!(slot instanceof FluidConfigSlot) || !(fluidConfig = (FluidConfigSlot)slot).getFilter().matches(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean trySetFilterOnShiftClick(int clickedSlot) {
        FluidVariant fluidVariant = FluidVariant.blank();
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)this.getCarried()).orElse(null);
        if (fluidHandler != null) {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                if (fluidInTank.isEmpty() || this.matchesAnyFilter(fluidInTank)) continue;
                fluidVariant = FluidVariant.of(fluidInTank);
                break;
            }
        }
        if (!fluidVariant.isBlank()) {
            for (Slot slot : this.slots) {
                FluidConfigSlot fluidConfig;
                if (!(slot instanceof FluidConfigSlot) || !(fluidConfig = (FluidConfigSlot)slot).getFilter().isBlank()) continue;
                this.setFilter(fluidConfig.getConfigIdx(), fluidVariant, false);
                return true;
            }
        }
        return false;
    }

    public void setFilter(int configIdx, FluidVariant variant, boolean sendPacket) {
        if (this.isClientSide() && sendPacket) {
            MdPackets.sendSetFilter(this.containerId, configIdx, variant);
        }
        ((FluidAttachedIo)this.attachment).setFilter(configIdx, variant);
    }
}

