/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.gui.menu;

import dev.technici4n.moderndynamics.attachment.Setting;
import dev.technici4n.moderndynamics.attachment.attached.AttachedIo;
import dev.technici4n.moderndynamics.attachment.settings.FilterInversionMode;
import dev.technici4n.moderndynamics.attachment.settings.RedstoneMode;
import dev.technici4n.moderndynamics.gui.menu.UpgradeSlot;
import dev.technici4n.moderndynamics.packets.MdPackets;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.function.BiConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AttachedIoMenu<A extends AttachedIo>
extends AbstractContainerMenu {
    public final PipeBlockEntity pipe;
    public final Direction side;
    public final A attachment;
    protected final Player player;

    public AttachedIoMenu(MenuType<?> menuType, int syncId, Inventory playerInventory, PipeBlockEntity pipe, Direction side, A attachment) {
        super(menuType, syncId);
        int i;
        this.pipe = pipe;
        this.side = side;
        this.attachment = attachment;
        this.player = playerInventory.player;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 123 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 181));
        }
        for (int k = 0; k < 4; ++k) {
            this.addSlot(new UpgradeSlot((AttachedIo)attachment, k, -18, 10 + k * 18));
        }
        this.syncEnum(FilterInversionMode.class, this::getFilterMode, this::setFilterMode);
        this.syncEnum(RedstoneMode.class, this::getRedstoneMode, this::setRedstoneMode);
    }

    protected <T extends Enum<T>> void syncEnum(final Class<T> enumClass, final Supplier<T> getter, final BiConsumer<T, Boolean> setter) {
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return ((Enum)getter.get()).ordinal();
            }

            public void set(int value) {
                setter.accept(((Enum[])enumClass.getEnumConstants())[value], false);
            }
        });
    }

    protected void syncShort(final IntSupplier getter, final BiConsumer<Integer, Boolean> setter) {
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return getter.getAsInt();
            }

            public void set(int value) {
                setter.accept(value, false);
            }
        });
    }

    protected boolean trySetFilterOnShiftClick(int clickedSlot) {
        return false;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        ItemStack stack = slot.getItem();
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (index < 36) {
            for (Slot otherSlot : this.slots) {
                int inserted;
                if (!(otherSlot instanceof UpgradeSlot) || !otherSlot.mayPlace(stack)) continue;
                if (ItemStack.isSameItemSameComponents((ItemStack)otherSlot.getItem(), (ItemStack)stack)) {
                    inserted = Math.min(stack.getCount(), otherSlot.getMaxStackSize() - otherSlot.getItem().getCount());
                    if (inserted <= 0) continue;
                    stack.shrink(inserted);
                    otherSlot.getItem().grow(inserted);
                    otherSlot.setChanged();
                    return ItemStack.EMPTY;
                }
                if (!otherSlot.getItem().isEmpty() || (inserted = Math.min(stack.getCount(), otherSlot.getMaxStackSize(stack))) <= 0) continue;
                otherSlot.set(stack.split(inserted));
                return ItemStack.EMPTY;
            }
            if (this.trySetFilterOnShiftClick(index)) {
                return ItemStack.EMPTY;
            }
            if (index < 27 ? this.moveItemStackTo(stack, 27, 36, false) : this.moveItemStackTo(stack, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
        } else if (slot instanceof UpgradeSlot && this.moveItemStackTo(stack, 0, 36, true)) {
            slot.setChanged();
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
    }

    public boolean stillValid(Player player) {
        if (this.isClientSide()) {
            return true;
        }
        BlockPos pos = this.pipe.getBlockPos();
        if (player.level().getBlockEntity(pos) != this.pipe) {
            return false;
        }
        if (player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 64.0) {
            return false;
        }
        return this.pipe.getAttachment(this.side) == this.attachment;
    }

    public FilterInversionMode getFilterMode() {
        return ((AttachedIo)this.attachment).getFilterInversion();
    }

    public void setFilterMode(FilterInversionMode value, boolean sendPacket) {
        if (this.isClientSide() && sendPacket) {
            MdPackets.sendSetFilterMode(this.containerId, value);
        }
        ((AttachedIo)this.attachment).setFilterInversion(value);
        this.pipe.setChanged();
    }

    public RedstoneMode getRedstoneMode() {
        return ((AttachedIo)this.attachment).getRedstoneMode();
    }

    public void setRedstoneMode(RedstoneMode redstoneMode, boolean sendPacket) {
        if (this.isClientSide() && sendPacket) {
            MdPackets.sendSetRedstoneMode(this.containerId, redstoneMode);
        }
        ((AttachedIo)this.attachment).setRedstoneMode(redstoneMode);
        this.pipe.setChanged();
    }

    public boolean isSettingSupported(Setting setting) {
        return ((AttachedIo)this.attachment).getSupportedSettings().contains((Object)setting);
    }

    public boolean isClientSide() {
        return this.player.getCommandSenderWorld().isClientSide();
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isEnabledViaRedstone() {
        return ((AttachedIo)this.attachment).isEnabledViaRedstone(this.pipe);
    }

    public boolean isAdvancedBehaviorAllowed() {
        return ((AttachedIo)this.attachment).isAdvancedBehaviorAllowed();
    }
}

