/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.extender;

import dev.technici4n.moderndynamics.MdBlock;
import dev.technici4n.moderndynamics.extender.MachineExtenderBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class MachineExtenderBlock
extends MdBlock {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");

    public MachineExtenderBlock() {
        super("machine_extender", BlockBehaviour.Properties.of().mapColor(MapColor.METAL).destroyTime(0.2f));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.getAxis().isVertical()) {
            return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(!level.getBlockState(currentPos.above()).is((Block)this)));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            BlockPos pos = context.getClickedPos();
            Level level = context.getLevel();
            state = (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(!level.getBlockState(pos.above()).is((Block)this)));
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (fromPos.equals((Object)pos.below()) && (blockEntity = level.getBlockEntity(pos)) instanceof MachineExtenderBlockEntity) {
            MachineExtenderBlockEntity sideExtender = (MachineExtenderBlockEntity)blockEntity;
            sideExtender.inNeighborUpdate = true;
            try {
                level.updateNeighborsAtExceptFromFacing(pos, (Block)this, Direction.DOWN);
            }
            finally {
                sideExtender.inNeighborUpdate = false;
            }
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }
}

