/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.data;

import com.google.gson.JsonElement;
import dev.technici4n.moderndynamics.attachment.upgrade.UpgradeTypeBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class AttachmentUpgradesProvider
implements DataProvider {
    private final PackOutput dataOutput;
    private final List<UpgradeTypeBuilder> builders = new ArrayList<UpgradeTypeBuilder>();

    public AttachmentUpgradesProvider(PackOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    private void genUpgrades() {
        this.vanillaUpgrade((ItemLike)Items.STICKY_PISTON, 1).itemSpeed(1);
        this.vanillaUpgrade((ItemLike)Items.HOPPER, 6).filterSlots(2).itemCount(5);
        this.vanillaUpgrade((ItemLike)Items.REPEATER, 3).itemTransferFrequency(1);
        this.vanillaUpgrade((ItemLike)Items.COMPARATOR, 1).advancedBehavior();
        this.vanillaUpgrade((ItemLike)Items.BUCKET, 3).fluidTransfer(1, 0);
        this.vanillaUpgrade((ItemLike)Items.CAULDRON, 1).fluidTransfer(0, 1);
        this.modUpgrade("ae2", "speed_card", 3).itemSpeed(1).itemTransferFrequency(1).fluidTransfer(0, 1);
        this.modUpgrade("ae2", "capacity_card", 6).filterSlots(2).itemCount(10).fluidTransfer(1, 0);
        this.modUpgrade("ae2", "fuzzy_card", 1).advancedBehavior();
        this.modUpgrade("immersiveengineering", "conveyor_basic", 32).itemCount(4);
        this.modUpgrade("immersiveengineering", "conveyor_extract", 3).itemSpeed(1).itemTransferFrequency(1);
        this.modUpgrade("immersiveengineering", "fluid_pipe", 3).fluidTransfer(1, 0);
        this.modUpgrade("immersiveengineering", "component_electronic", 6).filterSlots(2).advancedBehavior();
        this.modUpgrade("mekanism", "upgrade_speed", 3).itemSpeed(1).itemTransferFrequency(1).fluidTransfer(0, 1);
        this.modUpgrade("mekanism", "basic_control_circuit", 6).filterSlots(2).itemCount(10);
        this.modUpgrade("mekanism", "advanced_control_circuit", 6).filterSlots(2).itemCount(20).fluidTransfer(1, 0);
        this.modUpgrade("mekanism", "elite_control_circuit", 1).advancedBehavior();
        this.modUpgrade("modern_industrialization", "motor", 5).itemSpeed(1).itemTransferFrequency(1);
        this.modUpgrade("modern_industrialization", "robot_arm", 10).itemCount(16);
        this.modUpgrade("modern_industrialization", "pump", 9).fluidTransfer(1, 1);
        this.modUpgrade("modern_industrialization", "analog_circuit", 6).filterSlots(2).advancedBehavior();
        this.modUpgrade("refinedstorage", "upgrade", 6).filterSlots(2);
        this.modUpgrade("refinedstorage", "speed_upgrade", 3).itemSpeed(1).itemTransferFrequency(1).fluidTransfer(0, 1);
        this.modUpgrade("refinedstorage", "stack_upgrade", 4).itemCount(16).fluidTransfer(2, 0);
        this.modUpgrade("refinedstorage", "regulator_upgrade", 1).advancedBehavior();
        this.modUpgrade("techreborn", "overclocker_upgrade", 3).itemSpeed(1).itemTransferFrequency(1).fluidTransfer(0, 1);
        this.modUpgrade("techreborn", "electronic_circuit", 6).filterSlots(2).itemCount(10);
        this.modUpgrade("techreborn", "advanced_circuit", 6).filterSlots(2).itemCount(10).fluidTransfer(1, 0).advancedBehavior();
        this.modUpgrade("indrev", "speed_enhancer", 3).itemSpeed(1).itemTransferFrequency(1).fluidTransfer(0, 1);
        this.modUpgrade("indrev", "circuit_mk1", 6).filterSlots(2).itemCount(10);
        this.modUpgrade("indrev", "circuit_mk2", 6).filterSlots(2).itemCount(20).fluidTransfer(1, 0);
        this.modUpgrade("indrev", "circuit_mk3", 1).advancedBehavior();
    }

    private UpgradeTypeBuilder modUpgrade(String modid, String item, int slotLimit) {
        UpgradeTypeBuilder builder = new UpgradeTypeBuilder(modid, item, slotLimit);
        this.builders.add(builder);
        return builder;
    }

    private UpgradeTypeBuilder vanillaUpgrade(ItemLike item, int slotLimit) {
        UpgradeTypeBuilder builder = new UpgradeTypeBuilder(item, slotLimit);
        this.builders.add(builder);
        return builder;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.genUpgrades();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (UpgradeTypeBuilder builder : this.builders) {
            Path path = this.dataOutput.getOutputFolder().resolve("data/%s/attachment_upgrades/%s".formatted("moderndynamics", builder.getFileName()));
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)builder.toJson(), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Upgrades";
    }
}

