/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment.upgrade;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.technici4n.moderndynamics.attachment.upgrade.AttachmentUpgradesLoader;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class UpgradeTypeBuilder {
    private static final UpgradeTypeBuilder DUMMY = new UpgradeTypeBuilder((ItemLike)Items.AIR, 0);
    public final transient ICondition[] conditions;
    public final transient String path;
    private final String item;
    private final int slotLimit;
    private boolean enableAdvancedBehavior = false;
    private int addFilterSlots = 0;
    private int addItemCount = 0;
    private int addItemSpeed = 0;
    private int addItemTransferFrequency = 0;
    private int addFluidTransfer = 0;
    private int multiplyFluidTransfer = 0;

    public UpgradeTypeBuilder(String requiredMod, String itemId, int slotLimit) {
        this.conditions = new ICondition[]{new ModLoadedCondition(requiredMod)};
        this.item = requiredMod + ":" + itemId;
        this.path = requiredMod + "/" + itemId;
        this.slotLimit = slotLimit;
    }

    public UpgradeTypeBuilder(ItemLike upgrade, int slotLimit) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)upgrade.asItem());
        this.conditions = null;
        this.item = itemId.toString();
        this.path = itemId.getPath();
        this.slotLimit = slotLimit;
    }

    public UpgradeTypeBuilder advancedBehavior() {
        this.enableAdvancedBehavior = true;
        return this;
    }

    public UpgradeTypeBuilder filterSlots(int slots) {
        this.addFilterSlots = slots;
        return this;
    }

    public UpgradeTypeBuilder itemCount(int itemCount) {
        this.addItemCount = itemCount;
        return this;
    }

    public UpgradeTypeBuilder itemSpeed(int itemSpeed) {
        this.addItemSpeed = itemSpeed;
        return this;
    }

    public UpgradeTypeBuilder itemTransferFrequency(int frequency) {
        this.addItemTransferFrequency = frequency;
        return this;
    }

    public UpgradeTypeBuilder fluidTransfer(int add, int multiply) {
        this.addFluidTransfer = add;
        this.multiplyFluidTransfer = multiply;
        return this;
    }

    public String getFileName() {
        return this.path + ".json";
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (Field field : UpgradeTypeBuilder.class.getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) > 0) continue;
            try {
                if (field.get(this).equals(field.get(DUMMY))) continue;
                obj.add(field.getName(), AttachmentUpgradesLoader.GSON.toJsonTree(field.get(this)));
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
        if (this.conditions != null) {
            ICondition.writeConditions((DynamicOps)JsonOps.INSTANCE, (JsonObject)obj, Arrays.asList(this.conditions));
        }
        return obj;
    }
}

