/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.attachment;

import dev.technici4n.moderndynamics.attachment.AttachmentItem;
import dev.technici4n.moderndynamics.attachment.IoAttachmentType;
import dev.technici4n.moderndynamics.attachment.RenderedAttachment;
import dev.technici4n.moderndynamics.attachment.Setting;
import dev.technici4n.moderndynamics.attachment.attached.AttachedAttachment;
import dev.technici4n.moderndynamics.attachment.attached.FluidAttachedIo;
import dev.technici4n.moderndynamics.attachment.attached.ItemAttachedIo;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class IoAttachmentItem
extends AttachmentItem {
    private final IoAttachmentType type;

    public IoAttachmentItem(RenderedAttachment attachment, IoAttachmentType type) {
        super(attachment);
        this.type = type;
    }

    public IoAttachmentType getType() {
        return this.type;
    }

    @Override
    public AttachedAttachment createAttached(NodeHost host, CompoundTag configTag, HolderLookup.Provider registries) {
        if (host instanceof ItemHost) {
            return new ItemAttachedIo(this, configTag, () -> ((PipeBlockEntity)host.getPipe()).setChanged(), registries);
        }
        return new FluidAttachedIo(this, configTag, () -> ((PipeBlockEntity)host.getPipe()).setChanged(), registries);
    }

    public Set<Setting> getSupportedSettings() {
        EnumSet<Setting> result = EnumSet.noneOf(Setting.class);
        result.add(Setting.FILTER_INVERSION);
        result.add(Setting.FILTER_DAMAGE);
        result.add(Setting.FILTER_NBT);
        result.add(Setting.FILTER_MOD);
        result.add(Setting.FILTER_SIMILAR);
        switch (this.type) {
            case FILTER: {
                break;
            }
            case EXTRACTOR: {
                result.add(Setting.MAX_ITEMS_EXTRACTED);
                result.add(Setting.ROUTING_MODE);
                break;
            }
            case ATTRACTOR: {
                result.add(Setting.MAX_ITEMS_EXTRACTED);
                result.add(Setting.ROUTING_MODE);
            }
        }
        return result;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.translatable((String)"gui.moderndynamics.tooltip.attachment_upgrades").setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
    }
}

