/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container.slots;

import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;

public class SlotIronFurnace
extends Slot {
    private final Player player;
    private int removeCount;
    private BlockIronFurnaceTileBase te;

    public SlotIronFurnace(Player player, BlockIronFurnaceTileBase te, int slotIndex, int xPosition, int yPosition) {
        super((Container)te, slotIndex, xPosition, yPosition);
        this.player = player;
        this.te = te;
    }

    public boolean isActive() {
        return this.te.getAugmentGUI() == 0 && this.te.isFurnace();
    }

    public boolean mayPlace(ItemStack p_40231_) {
        return false;
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(thePlayer, stack);
    }

    public ItemStack remove(int p_39548_) {
        if (this.hasItem()) {
            this.removeCount += Math.min(p_39548_, this.getItem().getCount());
        }
        return super.remove(p_39548_);
    }

    protected void onQuickCraft(ItemStack stack, int p_75210_2_) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        if (!this.player.level().isClientSide && this.te instanceof BlockIronFurnaceTileBase) {
            this.te.unlockRecipes((ServerPlayer)this.player);
        }
        this.removeCount = 0;
    }

    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
        if (this.player instanceof ServerPlayer && this.container instanceof BlockIronFurnaceTileBase) {
            ((BlockIronFurnaceTileBase)this.container).unlockRecipes((ServerPlayer)this.player);
        }
        this.removeCount = 0;
        EventHooks.firePlayerSmeltedEvent((Player)this.player, (ItemStack)stack);
    }
}

