/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.compat.rei.Screens;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import io.wispforest.owo.compat.rei.ReiUIAdapter;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.init.compat.rei.OritechDisplay;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class OritechReiDisplay
implements DisplayCategory<Display> {
    protected final OritechRecipeType recipeType;
    private final Boolean isGenerator;
    private final List<ScreenProvider.GuiSlot> slots;
    private final InventorySlotAssignment slotOffsets;
    protected final ItemLike icon;
    private final ScreenProvider.ArrowConfiguration indicatorConfig;

    public OritechReiDisplay(OritechRecipeType recipeType, Class<? extends MachineBlockEntity> screenProviderSource, ItemLike icon) {
        BlockState blockState = Blocks.STONE.defaultBlockState();
        if (icon instanceof Block) {
            Block blockItem = (Block)icon;
            blockState = blockItem.defaultBlockState();
        }
        BlockState finalBlockState = blockState;
        this.recipeType = recipeType;
        try {
            MachineBlockEntity screenProvider = screenProviderSource.getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(new BlockPos(0, 0, 0), finalBlockState);
            this.isGenerator = screenProvider instanceof UpgradableGeneratorBlockEntity;
            this.slots = screenProvider.getGuiSlots();
            this.slotOffsets = screenProvider.getSlotAssignments();
            this.indicatorConfig = screenProvider.getIndicatorConfiguration();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        this.icon = icon;
    }

    public OritechReiDisplay(OritechRecipeType recipeType, ItemLike icon, boolean isGenerator, List<ScreenProvider.GuiSlot> slots, InventorySlotAssignment assignments) {
        this.recipeType = recipeType;
        this.icon = icon;
        this.isGenerator = isGenerator;
        this.slots = slots;
        this.slotOffsets = assignments;
        this.indicatorConfig = new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 80, 35, 29, 16, true);
    }

    public List<Widget> setupDisplay(Display display, Rectangle bounds) {
        ReiUIAdapter adapter = new ReiUIAdapter(bounds, Containers::verticalFlow);
        FlowLayout root = (FlowLayout)adapter.rootComponent();
        root.horizontalAlignment(HorizontalAlignment.CENTER).surface(Surface.PANEL).padding(Insets.of((int)4));
        this.fillDisplay(root, (OritechDisplay)display, (ReiUIAdapter<FlowLayout>)adapter);
        adapter.prepare();
        return List.of(adapter);
    }

    public int getDisplayHeight() {
        return 74;
    }

    public void fillDisplay(FlowLayout root, OritechDisplay display, ReiUIAdapter<FlowLayout> adapter) {
        int offsetX = 23;
        int offsetY = 17;
        List<EntryIngredient> inputEntries = display.getInputEntries();
        for (int i = 0; i < inputEntries.size(); ++i) {
            EntryIngredient entry = inputEntries.get(i);
            if (entry.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.inputStart() + i);
            int usedY = Math.clamp(2L, pos.y() - offsetY, this.getDisplayHeight() - 18 - 4);
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)entry).markInput()).positioning(Positioning.absolute((int)(pos.x() - offsetX), (int)usedY)));
        }
        if (this.isGenerator.booleanValue()) {
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createBurningFire((Point)new Point(0, 0))).positioning(Positioning.absolute((int)(this.indicatorConfig.x() - offsetX), (int)(this.indicatorConfig.y() - offsetY))));
        } else {
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createArrow((Point)new Point(0, 0))).positioning(Positioning.absolute((int)(this.indicatorConfig.x() - offsetX), (int)(this.indicatorConfig.y() - offsetY))));
        }
        List<EntryIngredient> outputEntries = display.getOutputEntries();
        for (int i = 0; i < outputEntries.size(); ++i) {
            EntryIngredient entry = outputEntries.get(i);
            if (entry.isEmpty()) continue;
            ScreenProvider.GuiSlot pos = this.slots.get(this.slotOffsets.outputStart() + i);
            root.child((Component)adapter.wrap((WidgetWithBounds)Widgets.createSlot((Point)new Point(0, 0)).entry((EntryStack)entry.get(0)).markOutput()).positioning(Positioning.absolute((int)(pos.x() - offsetX), (int)(pos.y() - offsetY))));
        }
        String duration = String.format("%.0f", Float.valueOf((float)((OritechRecipe)display.getEntry().value()).getTime() / 20.0f));
        root.child((Component)Components.label((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatable((String)"rei.title.oritech.cookingtime", (Object[])new Object[]{duration, ((OritechRecipe)display.getEntry().value()).getTime()})).lineHeight(7).positioning(Positioning.relative((int)90, (int)100)));
        if (((OritechRecipe)display.entry.value()).getFluidInput() != null && ((OritechRecipe)display.entry.value()).getFluidInput().amount() > 0L) {
            MutableComponent text;
            FluidIngredient fluidInput = ((OritechRecipe)display.entry.value()).getFluidInput();
            root.child((Component)BasicMachineScreen.createFluidRenderer(fluidInput.getFluidStacks().getFirst(), new ScreenProvider.BarConfiguration(4, 5, 16, 50)));
            MutableComponent mutableComponent = text = fluidInput.amount() > 0L ? net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{fluidInput.amount(), fluidInput.name()}) : net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_empty");
            if (fluidInput.hasTag()) {
                StringJoiner joiner = new StringJoiner(", ", "\n", "");
                joiner.setEmptyValue("");
                for (FluidStack fluidStack : fluidInput.getFluidStacks()) {
                    joiner.add(fluidStack.getName().getString());
                }
                MutableComponent fluidsText = MutableComponent.create((ComponentContents)net.minecraft.network.chat.Component.nullToEmpty((String)net.minecraft.network.chat.Component.nullToEmpty((String)joiner.toString()).getString(40)).getContents()).withColor(BasicMachineScreen.GRAY_TEXT_COLOR);
                text.append((net.minecraft.network.chat.Component)fluidsText);
            }
            TextureComponent foreGround = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)48, (int)0, (int)14, (int)50, (int)98, (int)96);
            foreGround.sizing(Sizing.fixed((int)18), Sizing.fixed((int)52));
            foreGround.positioning(Positioning.absolute((int)3, (int)4));
            foreGround.tooltip((net.minecraft.network.chat.Component)text);
            root.child((Component)foreGround);
        }
        if (!((OritechRecipe)display.entry.value()).getFluidOutputs().isEmpty()) {
            int tankCount = 0;
            int tankStartX = ((OritechRecipe)display.entry.value()).getFluidOutputs().size() > 1 ? 80 : 120;
            for (FluidStack fluidResult : ((OritechRecipe)display.entry.value()).getFluidOutputs()) {
                if (fluidResult.isEmpty()) continue;
                long amount = fluidResult.getAmount();
                root.child((Component)BasicMachineScreen.createFluidRenderer(fluidResult, new ScreenProvider.BarConfiguration(tankStartX + tankCount * 20 + 1, 5, 16, 50)));
                MutableComponent text = amount > 0L ? net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_content", (Object[])new Object[]{amount, FluidStackHooks.getName((FluidStack)fluidResult).getString()}) : net.minecraft.network.chat.Component.translatable((String)"tooltip.oritech.fluid_empty");
                TextureComponent foreGround = Components.texture((ResourceLocation)BasicMachineScreen.GUI_COMPONENTS, (int)48, (int)0, (int)14, (int)50, (int)98, (int)96);
                foreGround.sizing(Sizing.fixed((int)18), Sizing.fixed((int)52));
                foreGround.positioning(Positioning.absolute((int)(tankStartX + tankCount * 20), (int)4));
                foreGround.tooltip((net.minecraft.network.chat.Component)text);
                root.child((Component)foreGround);
                ++tankCount;
            }
        }
    }

    public CategoryIdentifier<? extends Display> getCategoryIdentifier() {
        return CategoryIdentifier.of((ResourceLocation)this.recipeType.getIdentifier());
    }

    public net.minecraft.network.chat.Component getTitle() {
        return net.minecraft.network.chat.Component.translatable((String)("rei.process." + String.valueOf(this.recipeType.getIdentifier())));
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)this.icon);
    }
}

