/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;
import rearth.oritech.block.entity.processing.RefineryModuleBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.ui.RefineryScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

public class RefineryBlockEntity
extends MultiblockMachineEntity
implements FluidApi.BlockProvider {
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK, SyncType.INITIAL})
    public final SimpleInOutFluidStorage ownStorage = new SimpleInOutFluidStorage(64L * FluidStackHooks.bucketAmount(), this::setChanged);
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK, SyncType.INITIAL})
    public final SimpleFluidStorage nodeA = new SimpleFluidStorage(4L * FluidStackHooks.bucketAmount(), this::setChanged);
    @SyncField(value={SyncType.GUI_TICK, SyncType.SPARSE_TICK, SyncType.INITIAL})
    public final SimpleFluidStorage nodeB = new SimpleFluidStorage(4L * FluidStackHooks.bucketAmount(), this::setChanged);
    @SyncField(value={SyncType.GUI_OPEN})
    private int moduleCount;

    public RefineryBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.REFINERY_ENTITY, pos, state, Oritech.CONFIG.processingMachines.refineryData.energyPerTick());
    }

    @Override
    public void serverTick(Level world, BlockPos pos, BlockState state, NetworkedBlockEntity blockEntity) {
        super.serverTick(world, pos, state, blockEntity);
        if (world.getGameTime() % 25L == 0L) {
            this.refreshModules();
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        this.ownStorage.writeNbt(nbt, "main");
        this.nodeA.writeNbt(nbt, "a");
        this.nodeB.writeNbt(nbt, "b");
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.ownStorage.readNbt(nbt, "main");
        this.nodeA.readNbt(nbt, "a");
        this.nodeB.readNbt(nbt, "b");
    }

    private void refreshModules() {
        BlockPos candidatePos;
        Optional candidate;
        this.moduleCount = 0;
        BlockPos startPos = this.worldPosition.above(2);
        for (int i = 0; i <= 1 && !(candidate = this.level.getBlockEntity(candidatePos = startPos.offset(0, i, 0), BlockEntitiesContent.REFINERY_MODULE_ENTITY)).isEmpty() && ((RefineryModuleBlockEntity)candidate.get()).isActive(((RefineryModuleBlockEntity)candidate.get()).getBlockState()); ++i) {
            ++this.moduleCount;
            ((RefineryModuleBlockEntity)candidate.get()).setOwningRefinery(this);
        }
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    @Override
    protected Optional<RecipeHolder<OritechRecipe>> getRecipe() {
        List candidates = Objects.requireNonNull(this.level).getRecipeManager().getRecipesFor((RecipeType)this.getOwnRecipeType(), this.getInputInventory(), this.level);
        Optional<RecipeHolder<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeInputMatchesTank(this.ownStorage.getInputContainer().getStack(), (OritechRecipe)candidate.value())).sorted(Comparator.comparingInt(a -> -((OritechRecipe)a.value()).getInputs().size())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return Optional.empty();
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        this.craftFluids(activeRecipe);
    }

    @Override
    public List<ItemStack> getCraftingResults(OritechRecipe activeRecipe) {
        List<ItemStack> results = activeRecipe.getResults();
        if (results.isEmpty()) {
            return List.of();
        }
        return List.of(results.getFirst().copyWithCount(results.getFirst().getCount() * this.getItemOutputMultiplier(activeRecipe)));
    }

    private void craftFluids(OritechRecipe activeRecipe) {
        this.ownStorage.getInputContainer().extract(this.ownStorage.getInputContainer().getStack().copyWithAmount(activeRecipe.getFluidInput().amount()), false);
        List<FluidStack> outputs = this.calculateOutputFluids(activeRecipe);
        for (int i = 0; i < outputs.size(); ++i) {
            FluidStack output = outputs.get(i);
            FluidApi.SingleSlotStorage outputTank = this.getOutputStorage(i);
            outputTank.insert(output, false);
        }
    }

    private List<FluidStack> calculateOutputFluids(OritechRecipe recipe) {
        if (recipe.getFluidOutputs().isEmpty()) {
            return List.of();
        }
        FluidStack outA = recipe.getFluidOutputs().get(0);
        if (recipe.getFluidOutputs().size() == 1) {
            return List.of(outA);
        }
        FluidStack outB = recipe.getFluidOutputs().get(1);
        return switch (this.moduleCount) {
            case 0 -> List.of(outA.copyWithAmount(outA.getAmount() * 2L));
            case 1 -> List.of(outA, outB.copyWithAmount(outB.getAmount() * 2L));
            case 2 -> recipe.getFluidOutputs();
            default -> throw new IllegalStateException("more than 2 modules is not supported/allowed");
        };
    }

    private int getItemOutputMultiplier(OritechRecipe recipe) {
        if (recipe.getFluidOutputs().size() <= 1) {
            return 1;
        }
        return this.getModuleCount() == 0 ? 2 : 1;
    }

    @Override
    public boolean canOutputRecipe(OritechRecipe recipe) {
        List<FluidStack> fluidOutputs = this.calculateOutputFluids(recipe);
        for (int i = 0; i <= this.moduleCount && i < fluidOutputs.size(); ++i) {
            FluidApi.SingleSlotStorage storage;
            long inserted;
            FluidStack fluidOutput = fluidOutputs.get(i);
            if (fluidOutput == null || fluidOutput.isEmpty() || (inserted = (storage = this.getOutputStorage(i)).insert(fluidOutput, true)) == fluidOutput.getAmount()) continue;
            return false;
        }
        return super.canOutputRecipe(recipe);
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new RefineryScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public ScreenProvider.BarConfiguration getFluidConfiguration() {
        return new ScreenProvider.BarConfiguration(28, 6, 21, 74);
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.refineryData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.refineryData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.REFINERY;
    }

    @Override
    protected void useEnergy() {
        super.useEnergy();
        if ((double)this.level.random.nextFloat() > 0.8) {
            return;
        }
        Direction facing = this.getFacing();
        Vec3 offsetLocal = Geometry.rotatePosition(new Vec3(0.3, 0.5, 0.3), facing);
        Vec3 emitPosition = Vec3.atCenterOf((Vec3i)this.worldPosition).add(offsetLocal);
        ParticleContent.COOLER_WORKING.spawn(this.level, emitPosition, (Object)1);
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 1);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 62, 8), new ScreenProvider.GuiSlot(1, 62, 61, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.REFINERY_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0), new Vec3i(0, 0, -1), new Vec3i(0, 1, -1), new Vec3i(1, 0, -1), new Vec3i(1, 1, -1), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0), new Vec3i(2, 0, -1), new Vec3i(2, 1, -1));
    }

    @Override
    public ScreenProvider.ArrowConfiguration getIndicatorConfiguration() {
        return new ScreenProvider.ArrowConfiguration(Oritech.id("textures/gui/modular/arrow_empty.png"), Oritech.id("textures/gui/modular/arrow_full.png"), 54, 35, 29, 16, true);
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of();
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable Direction direction) {
        return this.ownStorage;
    }

    public FluidApi.FluidStorage getFluidStorageForModule(BlockPos modulePos) {
        int yDist = modulePos.getY() - this.worldPosition.getY();
        if (yDist == 2) {
            return this.nodeA;
        }
        if (yDist == 3) {
            return this.nodeB;
        }
        throw new IllegalStateException("Module needs to be either 1 or 2 blocks above");
    }

    @Override
    public List<Tuple<Component, Component>> getExtraExtensionLabels() {
        return List.of(new Tuple((Object)Component.literal((String)("\ud83d\udce6: " + this.moduleCount)), (Object)Component.translatable((String)"tooltip.oritech.refinery_module_count")));
    }

    public FluidApi.SingleSlotStorage getOutputStorage(int i) {
        if (i == 0) {
            return this.ownStorage.getOutputContainer();
        }
        if (i == 1) {
            return this.nodeA;
        }
        if (i == 2) {
            return this.nodeB;
        }
        throw new IllegalArgumentException("Only has 2 storage modules, tried accessing: " + i);
    }
}

