/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.processing.PulverizerBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class FragmentForgeBlockEntity
extends MultiblockMachineEntity {
    @SyncField(value={SyncType.GUI_OPEN})
    private boolean hasByproductAddon;

    public FragmentForgeBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesContent.FRAGMENT_FORGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.fragmentForgeData.energyPerTick());
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.fragmentForgeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.fragmentForgeData.maxEnergyInsertion();
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.GRINDER;
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        CombiAddonEntity combi;
        AddonBlockEntity addonBlockEntity;
        if (addonBlock.state().getBlock().equals(BlockContent.MACHINE_YIELD_ADDON) || (addonBlockEntity = addonBlock.addonEntity()) instanceof CombiAddonEntity && (combi = (CombiAddonEntity)addonBlockEntity).getYieldCount() > 0) {
            this.hasByproductAddon = true;
        }
    }

    @Override
    protected void useEnergy() {
        super.useEnergy();
        if ((double)this.level.random.nextFloat() > 0.8) {
            return;
        }
        Direction facing = this.getFacing();
        Vec3 offsetLocal = Geometry.rotatePosition(new Vec3(0.4, 0.6, 0.5), facing);
        Vec3 emitPosition = Vec3.atCenterOf((Vec3i)this.worldPosition).add(offsetLocal);
        ParticleContent.GRINDER_WORKING.spawn(this.level, emitPosition, (Object)1);
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasByproductAddon = false;
    }

    @Override
    public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        this.hasByproductAddon = false;
        super.gatherAddonStats(addons);
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("byproductAddon", this.hasByproductAddon);
    }

    @Override
    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.hasByproductAddon = nbt.getBoolean("byproductAddon");
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<ItemStack> outputInventory, List<ItemStack> inputInventory) {
        super.craftItem(activeRecipe, outputInventory, inputInventory);
        PulverizerBlockEntity.combineSmallDusts(outputInventory, this.level);
    }

    @Override
    public List<ItemStack> getCraftingResults(OritechRecipe activeRecipe) {
        if (this.hasByproductAddon) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(activeRecipe.getResults().size());
            List<ItemStack> source = activeRecipe.getResults();
            for (int i = 0; i < source.size(); ++i) {
                ItemStack item = source.get(i);
                if (i == 0) {
                    result.add(item);
                    continue;
                }
                int newCount = item.getCount() * 2;
                ItemStack newItem = new ItemStack((ItemLike)item.getItem(), newCount);
                result.add(newItem);
            }
            return result;
        }
        return super.getCraftingResults(activeRecipe);
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 3);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 117, 20, true), new ScreenProvider.GuiSlot(2, 117, 38, true), new ScreenProvider.GuiSlot(3, 117, 56, true));
    }

    @Override
    public MenuType<?> getScreenHandlerType() {
        return ModScreens.GRINDER_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public List<Tuple<Component, Component>> getExtraExtensionLabels() {
        if (!this.hasByproductAddon) {
            return super.getExtraExtensionLabels();
        }
        return List.of(new Tuple((Object)Component.literal((String)"\ud83c\udf40: Enabled"), (Object)Component.translatable((String)"tooltip.oritech.machine.byproduct_bonus.tooltip")));
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<Vec3i> getCorePositions() {
        return List.of(new Vec3i(0, 1, 0), new Vec3i(0, 0, 1), new Vec3i(0, 1, 1), new Vec3i(1, 0, 1), new Vec3i(1, 1, 1), new Vec3i(1, 0, 0), new Vec3i(1, 1, 0));
    }

    @Override
    public List<Vec3i> getAddonSlots() {
        return List.of(new Vec3i(0, 0, 2), new Vec3i(1, 0, 2), new Vec3i(2, 0, 0), new Vec3i(1, 0, -1), new Vec3i(-1, 0, 1));
    }
}

