/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.pipes;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.pipes.AbstractPipeBlock;
import rearth.oritech.block.blocks.pipes.GenericPipeBlock;
import rearth.oritech.block.entity.interaction.PipeBoosterBlockEntity;

public abstract class GenericPipeInterfaceEntity
extends BlockEntity
implements BlockEntityTicker<GenericPipeInterfaceEntity> {
    public static final int MAX_SEARCH_COUNT = 2048;
    public BlockPos connectedBooster = BlockPos.ZERO;
    private PipeBoosterBlockEntity cachedBooster;

    public GenericPipeInterfaceEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isBoostAvailable() {
        PipeBoosterBlockEntity booster = this.tryGetCachedBooster();
        return booster != null && booster.canUseBoost();
    }

    public void onBoostUsed() {
        PipeBoosterBlockEntity booster = this.tryGetCachedBooster();
        if (booster != null) {
            booster.useBoost();
        }
    }

    @Nullable
    private PipeBoosterBlockEntity tryGetCachedBooster() {
        if (this.cachedBooster != null && this.cachedBooster.isRemoved()) {
            this.cachedBooster = null;
            this.connectedBooster = BlockPos.ZERO;
            return null;
        }
        if (this.connectedBooster == BlockPos.ZERO) {
            if (this.cachedBooster != null) {
                this.cachedBooster = null;
            }
            return null;
        }
        if (this.cachedBooster == null) {
            BlockEntity candidate = Objects.requireNonNull(this.level).getBlockEntity(this.connectedBooster);
            if (candidate instanceof PipeBoosterBlockEntity) {
                PipeBoosterBlockEntity booster;
                this.cachedBooster = booster = (PipeBoosterBlockEntity)candidate;
                return this.cachedBooster;
            }
            this.connectedBooster = BlockPos.ZERO;
            return null;
        }
        return this.cachedBooster;
    }

    public static void addNode(Level world, BlockPos pos, boolean isInterface, BlockState newState, PipeNetworkData data) {
        Oritech.LOGGER.debug("registering/updating node: " + String.valueOf(pos));
        data.pipes.add(pos);
        HashSet<BlockPos> connectedMachines = new HashSet<BlockPos>(6);
        AbstractPipeBlock block = (AbstractPipeBlock)newState.getBlock();
        for (Direction neighbor : Direction.values()) {
            BlockPos neighborPos = pos.relative(neighbor);
            Set neighborMap = data.machinePipeNeighbors.getOrDefault(neighborPos, new HashSet());
            if (block.hasMachineInDirection(neighbor, world, pos, block.apiValidationFunction())) {
                if (block.isConnectingInDirection(newState, neighbor, pos, world, false)) {
                    connectedMachines.add(pos.relative(neighbor));
                }
                neighborMap.add(neighbor.getOpposite());
            } else {
                neighborMap.remove(neighbor.getOpposite());
            }
            if (!neighborMap.isEmpty()) {
                data.machinePipeNeighbors.put(neighborPos, neighborMap);
                continue;
            }
            data.machinePipeNeighbors.remove(neighborPos);
        }
        if (isInterface) {
            data.machineInterfaces.put(pos, connectedMachines);
        } else {
            data.machineInterfaces.remove(pos);
        }
        GenericPipeInterfaceEntity.updateFromNode(world, pos, data);
    }

    public static void removeNode(Level world, BlockPos pos, boolean wasInterface, BlockState oldState, PipeNetworkData data) {
        Oritech.LOGGER.debug("removing node: " + String.valueOf(pos) + " | " + wasInterface);
        Integer oldNetwork = data.pipeNetworkLinks.getOrDefault(pos, -1);
        data.pipes.remove(pos);
        if (wasInterface) {
            data.machineInterfaces.remove(pos);
        }
        GenericPipeInterfaceEntity.removeStaleMachinePipeNeighbors(pos, data);
        data.pipeNetworks.remove(oldNetwork);
        data.pipeNetworkInterfaces.remove(oldNetwork);
        data.pipeNetworkLinks.remove(pos);
        if (oldNetwork != -1) {
            Block block = oldState.getBlock();
            for (Direction direction : Direction.values()) {
                GenericPipeBlock pipeBlock;
                if (block instanceof GenericPipeBlock && (Integer)oldState.getValue((Property)(pipeBlock = (GenericPipeBlock)block).directionToProperty(direction)) == GenericPipeBlock.NO_CONNECTION) continue;
                GenericPipeInterfaceEntity.updateFromNode(world, pos.relative(direction), data);
            }
        }
        data.setDirty();
    }

    private static void updateFromNode(Level world, BlockPos pos, PipeNetworkData data) {
        FloodFillSearch searchInstance = new FloodFillSearch(pos, data.pipes, world);
        HashSet<BlockPos> foundNetwork = new HashSet<BlockPos>(searchInstance.complete());
        Set<Tuple<BlockPos, Direction>> foundMachines = GenericPipeInterfaceEntity.findConnectedMachines(foundNetwork, data);
        Oritech.LOGGER.debug("Nodes:    " + foundNetwork.size() + " | " + String.valueOf(foundNetwork));
        Oritech.LOGGER.debug("Machines: " + foundMachines.size() + " | " + String.valueOf(foundMachines.stream().map(elem -> String.valueOf(elem.getA()) + ":" + String.valueOf(elem.getB())).toList()));
        int netID = foundNetwork.hashCode();
        data.pipeNetworks.put(netID, foundNetwork);
        data.pipeNetworkInterfaces.put(netID, foundMachines);
        HashSet<Integer> networksToRemove = new HashSet<Integer>();
        for (BlockPos node : foundNetwork) {
            networksToRemove.add(data.pipeNetworkLinks.getOrDefault(node, -1));
            data.pipeNetworkLinks.put(node, netID);
        }
        networksToRemove.stream().filter(i -> i != -1 && i != netID).forEach(i -> {
            data.pipeNetworks.remove(i);
            data.pipeNetworkInterfaces.remove(i);
        });
        data.setDirty();
    }

    private static Set<Tuple<BlockPos, Direction>> findConnectedMachines(Set<BlockPos> network, PipeNetworkData data) {
        HashSet<Tuple<BlockPos, Direction>> res = new HashSet<Tuple<BlockPos, Direction>>();
        for (BlockPos node : network) {
            if (!data.machineInterfaces.containsKey(node)) continue;
            for (BlockPos machinePos : data.machineInterfaces.get(node)) {
                BlockPos offset = machinePos.subtract((Vec3i)node);
                Direction direction = Direction.fromDelta((int)offset.getX(), (int)offset.getY(), (int)offset.getZ()).getOpposite();
                res.add((Tuple<BlockPos, Direction>)new Tuple((Object)machinePos, (Object)direction));
            }
        }
        return res;
    }

    public static Set<Tuple<BlockPos, Direction>> findNetworkTargets(BlockPos from, PipeNetworkData data) {
        Integer connectedNetwork = data.pipeNetworkLinks.getOrDefault(from, -1);
        if (connectedNetwork == -1) {
            return new HashSet<Tuple<BlockPos, Direction>>();
        }
        return data.pipeNetworkInterfaces.get(connectedNetwork);
    }

    public static void removeStaleMachinePipeNeighbors(BlockPos pos, PipeNetworkData data) {
        for (Direction neighbor : Direction.values()) {
            BlockPos machine = pos.relative(neighbor);
            Set<Direction> machineNeighbors = data.machinePipeNeighbors.get(machine);
            if (machineNeighbors == null) continue;
            machineNeighbors.remove(Direction.getNearest((Vec3)Vec3.atLowerCornerOf((Vec3i)pos.subtract((Vec3i)machine))));
            if (machineNeighbors.isEmpty()) {
                data.machinePipeNeighbors.remove(machine);
                continue;
            }
            data.machinePipeNeighbors.put(machine, machineNeighbors);
        }
    }

    public static final class PipeNetworkData
    extends SavedData {
        public final HashMap<BlockPos, Integer> pipeNetworkLinks = new HashMap();
        public final HashSet<BlockPos> pipes = new HashSet();
        public final HashMap<BlockPos, Set<BlockPos>> machineInterfaces = new HashMap();
        public final HashMap<Integer, Set<BlockPos>> pipeNetworks = new HashMap();
        public final HashMap<Integer, Set<Tuple<BlockPos, Direction>>> pipeNetworkInterfaces = new HashMap();
        public final HashMap<BlockPos, Set<Direction>> machinePipeNeighbors = new HashMap();
        public static SavedData.Factory<PipeNetworkData> TYPE = new SavedData.Factory(PipeNetworkData::new, PipeNetworkData::fromNbt, null);

        public int hashCode() {
            int result = this.pipeNetworkLinks.hashCode();
            result = 31 * result + this.pipes.hashCode();
            result = 31 * result + this.machineInterfaces.hashCode();
            result = 31 * result + this.pipeNetworks.hashCode();
            result = 31 * result + this.pipeNetworkInterfaces.hashCode();
            return result;
        }

        public static PipeNetworkData fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
            PipeNetworkData result = new PipeNetworkData();
            if (nbt.contains("pipeNetworkLinks", 9)) {
                ListTag pipeNetworkLinksList = nbt.getList("pipeNetworkLinks", 10);
                for (Tag element2 : pipeNetworkLinksList) {
                    CompoundTag entry = (CompoundTag)element2;
                    BlockPos pos = BlockPos.of((long)entry.getLong("pos"));
                    int id = entry.getInt("id");
                    result.pipeNetworkLinks.put(pos, id);
                }
            }
            if (nbt.contains("pipes", 9)) {
                ListTag pipesList = nbt.getList("pipes", 4);
                pipesList.stream().map(element -> BlockPos.of((long)((LongTag)element).getAsLong())).forEach(result.pipes::add);
            }
            if (nbt.contains("machineInterfaces", 10)) {
                CompoundTag machineInterfacesNbt = nbt.getCompound("machineInterfaces");
                for (String key : machineInterfacesNbt.getAllKeys()) {
                    BlockPos interfacePos = BlockPos.of((long)Long.parseLong(key));
                    long[] machinesArray = machineInterfacesNbt.getLongArray(key);
                    Set machines = Arrays.stream(machinesArray).mapToObj(BlockPos::of).collect(Collectors.toSet());
                    result.machineInterfaces.put(interfacePos, machines);
                }
            }
            if (nbt.contains("pipeNetworks", 10)) {
                CompoundTag pipeNetworksNbt = nbt.getCompound("pipeNetworks");
                for (String key : pipeNetworksNbt.getAllKeys()) {
                    int id = Integer.parseInt(key);
                    long[] networkArray = pipeNetworksNbt.getLongArray(key);
                    Set network = Arrays.stream(networkArray).mapToObj(BlockPos::of).collect(Collectors.toSet());
                    result.pipeNetworks.put(id, network);
                }
            }
            if (nbt.contains("pipeNetworkInterfaces", 10)) {
                CompoundTag pipeNetworkInterfacesNbt = nbt.getCompound("pipeNetworkInterfaces");
                for (String key : pipeNetworkInterfacesNbt.getAllKeys()) {
                    int id = Integer.parseInt(key);
                    ListTag interfacesList = pipeNetworkInterfacesNbt.getList(key, 10);
                    HashSet<Tuple> interfaces = new HashSet<Tuple>();
                    for (Tag interfaceElement : interfacesList) {
                        CompoundTag pairNbt = (CompoundTag)interfaceElement;
                        BlockPos pos = BlockPos.of((long)pairNbt.getLong("pos"));
                        Direction direction = Direction.byName((String)pairNbt.getString("direction"));
                        interfaces.add(new Tuple((Object)pos, (Object)direction));
                    }
                    result.pipeNetworkInterfaces.put(id, interfaces);
                }
            }
            if (nbt.contains("machinePipeNeighbors", 10)) {
                CompoundTag connectionPipeNeighborsNbt = nbt.getCompound("machinePipeNeighbors");
                for (String key : connectionPipeNeighborsNbt.getAllKeys()) {
                    BlockPos pos = BlockPos.of((long)Long.parseLong(key));
                    ListTag neighborsList = connectionPipeNeighborsNbt.getList(key, 8);
                    HashSet<Direction> neighbors = new HashSet<Direction>();
                    for (Tag neighborElement : neighborsList) {
                        Direction direction = Direction.byName((String)neighborElement.getAsString());
                        neighbors.add(direction);
                    }
                    result.machinePipeNeighbors.put(pos, neighbors);
                }
            }
            result.setDirty();
            return result;
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
            ListTag pipeNetworkLinksList = new ListTag();
            this.pipeNetworkLinks.forEach((pos, id) -> {
                CompoundTag entry = new CompoundTag();
                entry.putLong("pos", pos.asLong());
                entry.putInt("id", id.intValue());
                pipeNetworkLinksList.add((Object)entry);
            });
            nbt.put("pipeNetworkLinks", (Tag)pipeNetworkLinksList);
            ListTag pipesList = new ListTag();
            this.pipes.forEach(pos -> pipesList.add((Object)LongTag.valueOf((long)pos.asLong())));
            nbt.put("pipes", (Tag)pipesList);
            CompoundTag machineInterfacesNbt = new CompoundTag();
            this.machineInterfaces.forEach((interfacePos, machines) -> machineInterfacesNbt.putLongArray(Long.toString(interfacePos.asLong()), machines.stream().map(BlockPos::asLong).collect(Collectors.toList())));
            nbt.put("machineInterfaces", (Tag)machineInterfacesNbt);
            CompoundTag pipeNetworksNbt = new CompoundTag();
            this.pipeNetworks.forEach((id, network) -> pipeNetworksNbt.putLongArray(id.toString(), network.stream().map(BlockPos::asLong).collect(Collectors.toList())));
            nbt.put("pipeNetworks", (Tag)pipeNetworksNbt);
            CompoundTag pipeNetworkInterfacesNbt = new CompoundTag();
            this.pipeNetworkInterfaces.forEach((id, interfaces) -> {
                ListTag interfacesList = new ListTag();
                interfaces.forEach(pair -> {
                    CompoundTag pairNbt = new CompoundTag();
                    pairNbt.putLong("pos", ((BlockPos)pair.getA()).asLong());
                    pairNbt.putString("direction", ((Direction)pair.getB()).getName());
                    interfacesList.add((Object)pairNbt);
                });
                pipeNetworkInterfacesNbt.put(id.toString(), (Tag)interfacesList);
            });
            nbt.put("pipeNetworkInterfaces", (Tag)pipeNetworkInterfacesNbt);
            CompoundTag connectionPipeNeighborsNbt = new CompoundTag();
            this.machinePipeNeighbors.forEach((pos, neighbors) -> {
                ListTag neighborsList = new ListTag();
                neighbors.forEach(direction -> {
                    StringTag nbtElement = StringTag.valueOf((String)direction.getName());
                    neighborsList.add((Object)nbtElement);
                });
                connectionPipeNeighborsNbt.put(Long.toString(pos.asLong()), (Tag)neighborsList);
            });
            nbt.put("machinePipeNeighbors", (Tag)connectionPipeNeighborsNbt);
            return nbt;
        }
    }

    private static class FloodFillSearch {
        final HashSet<BlockPos> checkedPositions = new HashSet();
        final HashSet<BlockPos> nextTargets = new HashSet();
        final Deque<BlockPos> foundTargets = new ArrayDeque<BlockPos>();
        final HashSet<BlockPos> pipes;
        final Level world;

        public FloodFillSearch(BlockPos startPosition, HashSet<BlockPos> pipes, Level world) {
            this.pipes = pipes;
            this.world = world;
            this.nextTargets.add(startPosition);
        }

        public Deque<BlockPos> complete() {
            boolean active = true;
            while (active) {
                active = !this.nextGeneration();
            }
            return this.foundTargets;
        }

        public boolean nextGeneration() {
            HashSet currentGeneration = (HashSet)this.nextTargets.clone();
            for (BlockPos target : currentGeneration) {
                if (this.isValidTarget(target)) {
                    this.foundTargets.addLast(target);
                    this.addNeighborsToQueue(target);
                }
                this.checkedPositions.add(target);
                this.nextTargets.remove(target);
            }
            if (this.cutoffSearch()) {
                this.nextTargets.clear();
            }
            return this.nextTargets.isEmpty();
        }

        private boolean cutoffSearch() {
            return this.foundTargets.size() >= 2048;
        }

        private boolean isValidTarget(BlockPos target) {
            return this.pipes.contains(target);
        }

        private void addNeighborsToQueue(BlockPos self) {
            BlockState targetState = this.world.getBlockState(self);
            Direction[] directionArray = targetState.getBlock();
            if (!(directionArray instanceof AbstractPipeBlock)) {
                return;
            }
            AbstractPipeBlock targetBlock = (AbstractPipeBlock)directionArray;
            for (Direction direction : Direction.values()) {
                BlockPos neighbor = self.relative(direction);
                if (this.checkedPositions.contains(neighbor)) continue;
                if (!this.isValidTarget(neighbor)) {
                    this.checkedPositions.add(neighbor);
                    continue;
                }
                if (!targetBlock.isConnectingInDirection(targetState, direction, self, this.world, false)) continue;
                this.nextTargets.add(neighbor);
            }
        }
    }
}

