/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.reactor;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rearth.oritech.block.blocks.reactor.BaseReactorBlock;
import rearth.oritech.init.BlockContent;

public class ReactorRodBlock
extends BaseReactorBlock {
    private final int rodCount;
    private final int internalPulseCount;
    private static final VoxelShape SOLO_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape DUO_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape QUAD_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public ReactorRodBlock(BlockBehaviour.Properties settings, int rodCount, int internalPulseCount) {
        super(settings);
        this.rodCount = rodCount;
        this.internalPulseCount = internalPulseCount;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.LIT});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch (this.rodCount) {
            case 1 -> SOLO_SHAPE;
            case 2 -> DUO_SHAPE;
            case 4 -> QUAD_SHAPE;
            default -> SOLO_SHAPE;
        };
    }

    public int getRodCount() {
        return this.rodCount;
    }

    public int getInternalPulseCount() {
        return this.internalPulseCount;
    }

    @Override
    public Block requiredStackCeiling() {
        return BlockContent.REACTOR_FUEL_PORT;
    }
}

