/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.blocks.interaction;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.entity.interaction.DeepDrillEntity;
import rearth.oritech.util.MultiblockMachineController;
import rearth.oritech.util.TooltipHelper;

public class DeepDrillBlock
extends Block
implements EntityBlock {
    public DeepDrillBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)MultiblockMachine.ASSEMBLED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MultiblockMachine.ASSEMBLED}).add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            Boolean corePlaced;
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof DeepDrillEntity)) {
                return InteractionResult.SUCCESS;
            }
            DeepDrillEntity deepDrill = (DeepDrillEntity)entity;
            Boolean wasAssembled = (Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED);
            if (!wasAssembled.booleanValue() && (corePlaced = deepDrill.tryPlaceNextCore(player)).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            boolean isAssembled = deepDrill.initMultiblock(state);
            if (isAssembled && !wasAssembled.booleanValue()) {
                deepDrill.triggerSetupAnimation();
                return InteractionResult.SUCCESS;
            }
            if (!isAssembled) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine.missing_core"));
                return InteractionResult.SUCCESS;
            }
            if (!deepDrill.init(true)) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.deep_drill.ore_placement"));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof MultiblockMachineController) {
                MultiblockMachineController machineEntity = (MultiblockMachineController)entity;
                machineEntity.onControllerBroken();
            }
            if (entity instanceof DeepDrillEntity) {
                DeepDrillEntity storageBlock = (DeepDrillEntity)entity;
                NonNullList<ItemStack> stacks = storageBlock.inventory.heldStacks;
                for (ItemStack heldStack : stacks) {
                    if (heldStack.isEmpty()) continue;
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), heldStack);
                    world.addFreshEntity((Entity)itemEntity);
                }
                storageBlock.inventory.heldStacks.clear();
                storageBlock.inventory.setChanged();
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DeepDrillEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        TooltipHelper.addMachineTooltip(tooltip, this, this);
    }
}

