/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.base.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.TooltipHelper;

public abstract class FrameInteractionBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty HAS_FRAME = BooleanProperty.create((String)"has_frame");

    public FrameInteractionBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_FRAME, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, HAS_FRAME});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof FrameInteractionBlockEntity)) {
                return InteractionResult.SUCCESS;
            }
            FrameInteractionBlockEntity machineEntity = (FrameInteractionBlockEntity)entity;
            boolean frameValid = machineEntity.tryFindFrame();
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_FRAME, (Comparable)Boolean.valueOf(frameValid)));
            if (frameValid) {
                if (entity instanceof MachineAddonController) {
                    MachineAddonController addonController = (MachineAddonController)entity;
                    addonController.initAddons();
                }
                ExtendedMenuProvider handler = (ExtendedMenuProvider)world.getBlockEntity(pos);
                MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)handler);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.oritech.machine_frame.missing_frame"));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide() && ((Boolean)state.getValue((Property)HAS_FRAME)).booleanValue()) {
            FrameInteractionBlockEntity ownEntity = (FrameInteractionBlockEntity)world.getBlockEntity(pos);
            ownEntity.cleanup();
            if (ownEntity instanceof MachineAddonController) {
                MachineAddonController machineEntity = (MachineAddonController)((Object)ownEntity);
                machineEntity.resetAddons();
            }
            if (ownEntity instanceof ItemEnergyFrameInteractionBlockEntity) {
                ItemEnergyFrameInteractionBlockEntity itemContainer = (ItemEnergyFrameInteractionBlockEntity)ownEntity;
                NonNullList<ItemStack> stacks = itemContainer.inventory.heldStacks;
                for (ItemStack stack : stacks) {
                    if (stack.isEmpty()) continue;
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                    world.addFreshEntity((Entity)itemEntity);
                }
                itemContainer.inventory.heldStacks.clear();
                itemContainer.inventory.setChanged();
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        TooltipHelper.addMachineTooltip(tooltip, (Block)this, this);
    }
}

