/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.recipe.util;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import rearth.oritech.api.recipe.AtomicForgeRecipeBuilder;
import rearth.oritech.api.recipe.CentrifugeFluidRecipeBuilder;
import rearth.oritech.api.recipe.CentrifugeRecipeBuilder;
import rearth.oritech.api.recipe.FoundryRecipeBuilder;
import rearth.oritech.api.recipe.GrinderRecipeBuilder;
import rearth.oritech.api.recipe.OritechRecipeBuilder;
import rearth.oritech.api.recipe.OritechRecipeGenerator;
import rearth.oritech.api.recipe.PulverizerRecipeBuilder;
import rearth.oritech.api.recipe.RefineryRecipeBuilder;
import rearth.oritech.api.recipe.util.RecipeHelpers;
import rearth.oritech.init.FluidContent;

public class MetalProcessingChainBuilder {
    private String metalName;
    private String resourcePath = "";
    private Ingredient ore;
    private Ingredient rawOreIngredient;
    private Item rawOreItem;
    private Item rawOreByproduct;
    private Ingredient ingotIngredient;
    private Item ingotItem;
    private Ingredient nuggetIngredient;
    private Item nuggetItem;
    private Ingredient clumpIngredient;
    private Item clumpItem;
    private Item smallClumpItem;
    private Item dustItem;
    private Item smallDustItem;
    private Item centrifugeResult;
    private int centrifugeAmount;
    private Item dustByproduct;
    private Item clumpByproduct;
    private int byproductAmount = 3;
    private Ingredient gemIngredient;
    private Item gemItem;
    private Ingredient gemCatalyst;
    private float timeMultiplier = 1.0f;
    private boolean vanillaProcessing = false;
    private boolean skipCompactingRecipes = false;

    private MetalProcessingChainBuilder(String metalName) {
        this.metalName = metalName;
    }

    public static MetalProcessingChainBuilder build(String metalName) {
        return new MetalProcessingChainBuilder(metalName);
    }

    public MetalProcessingChainBuilder resourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
        return this;
    }

    public MetalProcessingChainBuilder ore(Ingredient ore) {
        this.ore = ore;
        return this;
    }

    public MetalProcessingChainBuilder ore(TagKey<Item> oreTag) {
        return this.ore(Ingredient.of(oreTag));
    }

    public MetalProcessingChainBuilder ore(ItemLike ore) {
        return this.ore(Ingredient.of((ItemLike[])new ItemLike[]{ore}));
    }

    public MetalProcessingChainBuilder rawOre(Ingredient rawOreIngredient, Item rawOre) {
        this.rawOreIngredient = rawOreIngredient;
        this.rawOreItem = rawOre;
        return this;
    }

    public MetalProcessingChainBuilder rawOre(TagKey<Item> rawOreTag, Item rawOre) {
        return this.rawOre(Ingredient.of(rawOreTag), rawOre);
    }

    public MetalProcessingChainBuilder rawOre(Item rawOre) {
        return this.rawOre(Ingredient.of((ItemLike[])new ItemLike[]{rawOre}), rawOre);
    }

    public MetalProcessingChainBuilder rawOreByproduct(Item byproduct) {
        this.rawOreByproduct = byproduct;
        return this;
    }

    public MetalProcessingChainBuilder ingot(Ingredient ingotIngredient, Item ingot) {
        this.ingotIngredient = ingotIngredient;
        this.ingotItem = ingot;
        return this;
    }

    public MetalProcessingChainBuilder ingot(TagKey<Item> ingotTag, Item ingot) {
        return this.ingot(Ingredient.of(ingotTag), ingot);
    }

    public MetalProcessingChainBuilder ingot(Item ingot) {
        return this.ingot(Ingredient.of((ItemLike[])new ItemLike[]{ingot}), ingot);
    }

    public MetalProcessingChainBuilder nugget(Ingredient nuggetIngredient, Item nugget) {
        this.nuggetIngredient = nuggetIngredient;
        this.nuggetItem = nugget;
        return this;
    }

    public MetalProcessingChainBuilder nugget(TagKey<Item> nuggetTag, Item nugget) {
        return this.nugget(Ingredient.of(nuggetTag), nugget);
    }

    public MetalProcessingChainBuilder nugget(Item nugget) {
        return this.nugget(Ingredient.of((ItemLike[])new ItemLike[]{nugget}), nugget);
    }

    public MetalProcessingChainBuilder clump(Ingredient clumpIngredient, Item clump) {
        this.clumpIngredient = clumpIngredient;
        this.clumpItem = clump;
        return this;
    }

    public MetalProcessingChainBuilder clump(TagKey<Item> clumpTag, Item clump) {
        return this.clump(Ingredient.of(clumpTag), clump);
    }

    public MetalProcessingChainBuilder clump(Item clump) {
        return this.clump(Ingredient.of((ItemLike[])new ItemLike[]{clump}), clump);
    }

    public MetalProcessingChainBuilder smallClump(Item smallClump) {
        this.smallClumpItem = smallClump;
        return this;
    }

    public MetalProcessingChainBuilder centrifugeResult(Item result, int amount) {
        this.centrifugeResult = result;
        this.centrifugeAmount = amount;
        return this;
    }

    public MetalProcessingChainBuilder centrifugeResult(Item result) {
        return this.centrifugeResult(result, 1);
    }

    public MetalProcessingChainBuilder clumpByproduct(Item byproduct) {
        this.clumpByproduct = byproduct;
        return this;
    }

    public MetalProcessingChainBuilder dustByproduct(Item byproduct) {
        this.dustByproduct = byproduct;
        return this;
    }

    public MetalProcessingChainBuilder byproductAmount(int amount) {
        this.byproductAmount = amount;
        return this;
    }

    public MetalProcessingChainBuilder dust(Item dust) {
        this.dustItem = dust;
        return this;
    }

    public MetalProcessingChainBuilder smallDust(Item smallDust) {
        this.smallDustItem = smallDust;
        return this;
    }

    public MetalProcessingChainBuilder gem(Ingredient gemIngredient, Item gem) {
        this.gemIngredient = gemIngredient;
        this.gemItem = gem;
        return this;
    }

    public MetalProcessingChainBuilder gem(TagKey<Item> gemTag, Item gem) {
        return this.gem(Ingredient.of(gemTag), gem);
    }

    public MetalProcessingChainBuilder gem(Item gem) {
        return this.gem(Ingredient.of((ItemLike[])new ItemLike[]{gem}), gem);
    }

    public MetalProcessingChainBuilder gemCatalyst(Ingredient gemCatalyst) {
        this.gemCatalyst = gemCatalyst;
        return this;
    }

    public MetalProcessingChainBuilder gemCatalyst(TagKey<Item> gemCatalyst) {
        return this.gemCatalyst(Ingredient.of(gemCatalyst));
    }

    public MetalProcessingChainBuilder gemCatalyst(Item gemCatalyst) {
        return this.gemCatalyst(Ingredient.of((ItemLike[])new ItemLike[]{gemCatalyst}));
    }

    public MetalProcessingChainBuilder timeMultiplier(float timeMultiplier) {
        this.timeMultiplier = timeMultiplier;
        return this;
    }

    public MetalProcessingChainBuilder vanillaProcessing() {
        this.vanillaProcessing = true;
        return this;
    }

    public MetalProcessingChainBuilder skipCompacting() {
        this.skipCompactingRecipes = true;
        return this;
    }

    private void validate(String path) throws IllegalStateException {
        if (this.ore == null) {
            throw new IllegalStateException("ore is required for metal processing chain " + path);
        }
        if (this.rawOreItem == null) {
            throw new IllegalStateException("raw ore is required for metal processing chain " + path);
        }
        if ((this.dustItem != null || this.vanillaProcessing) && this.ingotItem == null) {
            throw new IllegalStateException("ingot is required if dust is provided or vanilla processing is required for metal processing chain " + path);
        }
        if ((this.smallClumpItem != null || this.smallDustItem != null) && this.nuggetItem == null) {
            throw new IllegalStateException("nugget item is required if small clump or small dust are provided for metal processing chain " + path);
        }
        if (this.centrifugeResult != null && this.centrifugeAmount < 1) {
            throw new IllegalStateException("centrifugeAmount must be >= 1 if centrifugeOutput is provided for metal processing chain " + path);
        }
        if (this.clumpItem != null && this.centrifugeResult == null && this.gemItem == null) {
            throw new IllegalStateException("either centrifugeResult or gemItem is required if clump is provided for metal processing chain " + path);
        }
    }

    public void export(RecipeOutput exporter) {
        this.validate(this.resourcePath + "ore/" + this.metalName);
        PulverizerRecipeBuilder.build().input(this.ore).result(this.rawOreItem, 2).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "ore/" + this.metalName);
        OritechRecipeBuilder grinderOreRecipe = GrinderRecipeBuilder.build().input(this.ore).result(this.rawOreItem, 2).time(140).timeMultiplier(this.timeMultiplier);
        if (this.rawOreByproduct != null) {
            grinderOreRecipe.result(this.rawOreByproduct);
        }
        grinderOreRecipe.export(exporter, this.resourcePath + "ore/" + this.metalName);
        if (this.dustItem != null) {
            PulverizerRecipeBuilder.build().input(this.rawOreIngredient).result(this.dustItem).result(this.firstNonNullOptional(this.smallDustItem, this.nuggetItem), 3).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "raw/" + this.metalName);
        }
        if (this.clumpItem != null || this.dustItem != null) {
            GrinderRecipeBuilder.build().input(this.rawOreIngredient).result(this.firstNonNull(this.clumpItem, this.dustItem)).result(this.firstNonNullOptional(this.smallClumpItem, this.smallDustItem, this.nuggetItem), 3).result((Optional<Item>)Optional.fromNullable((Object)this.clumpByproduct), this.byproductAmount).time(140).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "raw/" + this.metalName);
        }
        if (this.clumpItem != null || this.dustItem != null) {
            RefineryRecipeBuilder.build().input(this.rawOreIngredient).fluidInput((Fluid)FluidContent.STILL_SHEOL_FIRE.get(), 0.25f).result(this.firstNonNull(this.clumpItem, this.dustItem), 2).fluidOutput((Fluid)Fluids.LAVA, 0.1f).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "rawsheol/" + this.metalName);
        }
        if (this.clumpItem != null) {
            CentrifugeRecipeBuilder.build().input(this.clumpIngredient).result(this.firstNonNull(this.centrifugeResult, this.gemItem), this.centrifugeResult != null ? this.centrifugeAmount : 1).result((Optional<Item>)Optional.fromNullable((Object)this.dustByproduct), this.byproductAmount).timeMultiplier(this.timeMultiplier).export(exporter, this.resourcePath + "clump/" + this.metalName);
            CentrifugeFluidRecipeBuilder.build().input(this.clumpIngredient).fluidInput((Fluid)Fluids.WATER).result(this.firstNonNull(this.centrifugeResult, this.gemItem), this.centrifugeResult != null ? this.centrifugeAmount * 2 : 2).timeMultiplier(this.timeMultiplier * 1.5f).export(exporter, this.resourcePath + "clump/" + this.metalName);
            CentrifugeFluidRecipeBuilder.build().input(this.clumpIngredient).fluidInput((Fluid)FluidContent.STILL_SULFURIC_ACID.get()).result(this.firstNonNull(this.centrifugeResult, this.gemItem), this.centrifugeResult != null ? this.centrifugeAmount * 3 : 3).fluidOutput((Fluid)FluidContent.STILL_MINERAL_SLURRY.get(), 0.25f).timeMultiplier(this.timeMultiplier * 1.5f).export(exporter, this.resourcePath + "clumpacid/" + this.metalName);
        }
        if (this.gemIngredient != null) {
            AtomicForgeRecipeBuilder.build().input(this.gemIngredient).input(this.gemCatalyst).input(this.gemCatalyst).result(this.dustItem, 2).time(20).export(exporter, this.resourcePath + "dust/" + this.metalName);
            FoundryRecipeBuilder.build().input(this.gemIngredient).input(this.gemIngredient).result(this.ingotItem, 3).export(exporter, this.resourcePath + "gem/" + this.metalName);
        }
        if (this.dustItem != null) {
            RecipeHelpers.addDustRecipe(exporter, this.ingotIngredient, this.dustItem, this.resourcePath + "dust/" + this.metalName);
        }
        if (this.smallDustItem != null) {
            RecipeHelpers.addDustRecipe(exporter, this.nuggetIngredient, this.smallDustItem, this.resourcePath + "smalldust/" + this.metalName);
        }
        if (this.vanillaProcessing) {
            if (this.dustItem != null) {
                OritechRecipeGenerator.oreSmelting(exporter, List.of(this.dustItem), RecipeCategory.MISC, (ItemLike)this.ingotItem, 1.0f, 200, "oritech");
                OritechRecipeGenerator.oreBlasting(exporter, List.of(this.dustItem), RecipeCategory.MISC, (ItemLike)this.ingotItem, 1.0f, 100, "oritech");
                OritechRecipeGenerator.threeByThreePacker((RecipeOutput)exporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)this.dustItem, (ItemLike)this.smallDustItem);
            }
            if (this.smallDustItem != null) {
                OritechRecipeGenerator.oreSmelting(exporter, List.of(this.smallDustItem), RecipeCategory.MISC, (ItemLike)this.nuggetItem, 0.5f, 50, "oritech");
                OritechRecipeGenerator.oreBlasting(exporter, List.of(this.smallDustItem), RecipeCategory.MISC, (ItemLike)this.nuggetItem, 0.5f, 25, "oritech");
            }
            if (this.gemItem != null) {
                OritechRecipeGenerator.oreSmelting(exporter, List.of(this.gemItem), RecipeCategory.MISC, (ItemLike)this.ingotItem, 1.0f, 200, "oritech");
                OritechRecipeGenerator.oreBlasting(exporter, List.of(this.gemItem), RecipeCategory.MISC, (ItemLike)this.ingotItem, 1.0f, 100, "oritech");
            }
            if (this.clumpItem != null && this.smallClumpItem != null) {
                OritechRecipeGenerator.threeByThreePacker((RecipeOutput)exporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)this.clumpItem, (ItemLike)this.smallClumpItem);
            }
            if (this.nuggetItem != null && !this.skipCompactingRecipes) {
                OritechRecipeGenerator.threeByThreePacker((RecipeOutput)exporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)this.ingotItem, (ItemLike)this.nuggetItem);
                OritechRecipeGenerator.threeByThreePacker((RecipeOutput)exporter, (RecipeCategory)RecipeCategory.MISC, (ItemLike)this.nuggetItem, (ItemLike)this.ingotItem);
            }
        }
    }

    private Item firstNonNull(Item ... items) {
        return (Item)Iterables.find(Arrays.asList(items), (Predicate)Predicates.notNull());
    }

    private Optional<Item> firstNonNullOptional(Item ... items) {
        return Iterables.tryFind(Arrays.asList(items), (Predicate)Predicates.notNull());
    }
}

