/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.fluid.containers;

import com.mojang.serialization.DynamicOps;
import dev.architectury.fluid.FluidStack;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.api.networking.UpdatableField;

public class SimpleFluidStorage
extends FluidApi.SingleSlotStorage
implements UpdatableField<Void, FluidStack> {
    private FluidStack content;
    private final Long capacity;
    private final Runnable onUpdate;

    public static Long transfer(SimpleFluidStorage from, SimpleFluidStorage to, long maxAmount, boolean simulate) {
        long extracted = from.extract(FluidStack.create((Fluid)from.getFluid(), (long)maxAmount, (DataComponentPatch)from.getChanges()), true);
        long inserted = to.insert(FluidStack.create((Fluid)from.getFluid(), (long)extracted, (DataComponentPatch)from.getChanges()), simulate);
        extracted = from.extract(FluidStack.create((Fluid)from.getFluid(), (long)inserted, (DataComponentPatch)from.getChanges()), simulate);
        if (extracted > 0L && !simulate) {
            from.update();
            to.update();
        }
        return extracted;
    }

    public SimpleFluidStorage(Long capacity, Runnable onUpdate) {
        this.capacity = capacity;
        this.onUpdate = onUpdate;
        this.content = FluidStack.create((Fluid)this.getEmptyVariant(), (long)0L);
    }

    public Fluid getEmptyVariant() {
        return Fluids.EMPTY;
    }

    public SimpleFluidStorage(Long capacity) {
        this(capacity, () -> {});
    }

    @Override
    public long insert(FluidStack toInsert, boolean simulate) {
        return SimpleInOutFluidStorage.insertTo(toInsert, simulate, this.capacity, this.content, stack -> {
            this.content = stack;
        });
    }

    @Override
    public long extract(FluidStack toExtract, boolean simulate) {
        return SimpleInOutFluidStorage.extractFrom(toExtract, simulate, this.content);
    }

    @Override
    public List<FluidStack> getContent() {
        return List.of(this.content);
    }

    public void writeNbt(CompoundTag nbt, String suffix) {
        FluidStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.content).result().ifPresent(tag -> nbt.put("fluid" + suffix, tag));
    }

    public void readNbt(CompoundTag nbt, String suffix) {
        this.content = FluidStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("fluid" + suffix)).result().orElse(FluidStack.empty());
    }

    public void setAmount(long amount) {
        this.content.setAmount(amount);
    }

    public long getAmount() {
        return this.content.getAmount();
    }

    public void setFluid(Fluid fluid) {
        this.content = FluidStack.create((Fluid)fluid, (long)this.getAmount(), (DataComponentPatch)this.getChanges());
    }

    public Fluid getFluid() {
        return this.content.getFluid();
    }

    public void setChanges(DataComponentPatch data) {
        this.content = FluidStack.create((Fluid)this.getFluid(), (long)this.getAmount(), (DataComponentPatch)data);
    }

    public DataComponentPatch getChanges() {
        return this.content.getPatch();
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    @Override
    public void setStack(FluidStack stack) {
        this.content = stack.copy();
    }

    @Override
    public FluidStack getStack() {
        return this.content;
    }

    @Override
    public FluidStack getDeltaData() {
        return this.content;
    }

    @Override
    public Void getFullData() {
        return null;
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        return true;
    }

    @Override
    public StreamCodec<? extends ByteBuf, FluidStack> getDeltaCodec() {
        return NetworkManager.FLUID_STACK_STREAM_CODEC;
    }

    @Override
    public StreamCodec<? extends ByteBuf, Void> getFullCodec() {
        return null;
    }

    @Override
    public void handleFullUpdate(Void updatedData) {
    }

    @Override
    public void handleDeltaUpdate(FluidStack updatedData) {
        this.setStack(updatedData);
    }
}

