/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import java.util.Optional;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ProjectileCalculator {
    private static final double TIME_STEP = 0.05;
    private static final int MAX_ITERATIONS = 2000;
    private static final double COLLISION_THRESHOLD = 0.001;

    public static Vec3 calculatePreciseImpactPoint(Level level, Vec3 startPos, Vec3 launchVector, double velocity, double gravity) {
        Vec3 currentPos = startPos;
        Vec3 currentVelocity = launchVector.m_82541_().m_82490_(velocity);
        Vec3 previousPos = startPos;
        for (int i = 0; i < 2000; ++i) {
            Vec3 nextPos = currentPos.m_82520_(currentVelocity.f_82479_ * 0.05, currentVelocity.f_82480_ * 0.05, currentVelocity.f_82481_ * 0.05);
            currentVelocity = currentVelocity.m_82520_(0.0, gravity * 0.05, 0.0);
            Optional<Vec3> collisionPoint = ProjectileCalculator.checkCollision(level, previousPos, nextPos);
            if (collisionPoint.isPresent()) {
                return ProjectileCalculator.refineCollisionPoint(level, previousPos, collisionPoint.get());
            }
            if (nextPos.f_82480_ < (double)level.m_141937_()) {
                return new Vec3(nextPos.f_82479_, (double)level.m_141937_(), nextPos.f_82481_);
            }
            previousPos = currentPos;
            currentPos = nextPos;
        }
        return currentPos;
    }

    private static Optional<Vec3> checkCollision(Level level, Vec3 start, Vec3 end) {
        BlockHitResult hitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return Optional.of(hitResult.m_82450_());
        }
        return Optional.empty();
    }

    private static Vec3 refineCollisionPoint(Level level, Vec3 safePoint, Vec3 collisionPoint) {
        Vec3 low = safePoint;
        Vec3 high = collisionPoint;
        Vec3 bestPoint = collisionPoint;
        for (int i = 0; i < 10; ++i) {
            Vec3 mid = low.m_82549_(high.m_82546_(low).m_82490_(0.5));
            Optional<Vec3> collision = ProjectileCalculator.checkCollision(level, low, mid);
            if (collision.isPresent()) {
                high = mid;
                bestPoint = collision.get();
                continue;
            }
            low = mid;
        }
        return bestPoint;
    }
}

