/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.GunsDataMessage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="superbwarfare")
public class GunsTool {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MinecraftServer server = player2.m_20194_();
            if (server != null && server.m_7779_(player2.m_36316_())) {
                return;
            }
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)GunsDataMessage.create());
        }
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        PlayerList players = event.getPlayerList();
        MinecraftServer server = players.m_7873_();
        GunsDataMessage message = GunsDataMessage.create();
        for (ServerPlayer player : players.m_11314_()) {
            if (server.m_7779_(player.m_36316_())) continue;
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        }
    }

    public static void setGunIntTag(ItemStack stack, String name, int num) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag data = tag.m_128469_("GunData");
        data.m_128405_(name, num);
        stack.m_41700_("GunData", (Tag)data);
    }

    public static int getGunIntTag(CompoundTag tag, String name) {
        return GunsTool.getGunIntTag(tag, name, 0);
    }

    public static int getGunIntTag(CompoundTag tag, String name, int defaultValue) {
        CompoundTag data = tag.m_128469_("GunData");
        if (!data.m_128441_(name)) {
            return defaultValue;
        }
        return data.m_128451_(name);
    }

    public static double getGunDoubleTag(ItemStack stack, String name) {
        return GunsTool.getGunDoubleTag(stack, name, 0.0);
    }

    public static double getGunDoubleTag(ItemStack stack, String name, double defaultValue) {
        CompoundTag data = stack.m_41784_().m_128469_("GunData");
        if (!data.m_128441_(name)) {
            return defaultValue;
        }
        return data.m_128459_(name);
    }

    @Nullable
    public static UUID getGunUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("GunData")) {
            return null;
        }
        CompoundTag data = tag.m_128469_("GunData");
        if (!data.m_128403_("UUID")) {
            return null;
        }
        return data.m_128342_("UUID");
    }
}

