/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipeData;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingResult;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class VehicleAssemblingRecipe
implements Recipe<Inventory> {
    private final ResourceLocation id;
    private final Category category;
    private final VehicleAssemblingResult result;
    private final List<VehicleAssemblingIngredient> inputs;

    public VehicleAssemblingRecipe(ResourceLocation id, VehicleAssemblingRecipeData data) {
        this(id, Category.getCategory(data.getCategory()), data.getResult(), data.getInputs());
    }

    public VehicleAssemblingRecipe(ResourceLocation id, Category recipeCategory, VehicleAssemblingResult result, List<VehicleAssemblingIngredient> inputs) {
        this.id = id;
        this.category = recipeCategory;
        this.result = result;
        this.inputs = inputs;
    }

    @ParametersAreNonnullByDefault
    public boolean matches(Inventory pContainer, Level pLevel) {
        return false;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(Inventory pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.getResult().m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.VEHICLE_ASSEMBLING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.VEHICLE_ASSEMBLING_TYPE.get();
    }

    public Category getCategory() {
        return this.category;
    }

    public VehicleAssemblingResult getResult() {
        return this.result;
    }

    public List<VehicleAssemblingIngredient> getInputs() {
        return this.inputs;
    }

    public static enum Category {
        LAND("land"),
        DEFENSE("defense"),
        AIRCRAFT("aircraft"),
        CIVILIAN("civilian"),
        WATER("water"),
        MISC("misc");

        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Category getCategory(String name) {
            for (Category category : Category.values()) {
                if (!category.getName().equals(name)) continue;
                return category;
            }
            return MISC;
        }
    }
}

